/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.mutation;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceGAIndividual;
import eva2.optimization.operator.mutation.InterfaceMutation;
import eva2.optimization.population.Population;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;
import java.util.BitSet;

@Description(value="This mutation operator inverts n successive bits.")
public class MutateGAInvertBits
implements InterfaceMutation,
Serializable {
    private int numberOfMutations = 1;
    private int maxInveredBits = 5;

    public MutateGAInvertBits() {
    }

    public MutateGAInvertBits(MutateGAInvertBits mutator) {
        this.numberOfMutations = mutator.numberOfMutations;
        this.maxInveredBits = mutator.maxInveredBits;
    }

    @Override
    public Object clone() {
        return new MutateGAInvertBits(this);
    }

    @Override
    public boolean equals(Object mutator) {
        if (mutator instanceof MutateGAInvertBits) {
            MutateGAInvertBits mut = (MutateGAInvertBits)mutator;
            if (this.numberOfMutations != mut.numberOfMutations) {
                return false;
            }
            return this.maxInveredBits == mut.maxInveredBits;
        }
        return false;
    }

    @Override
    public void initialize(AbstractEAIndividual individual, InterfaceOptimizationProblem opt) {
    }

    @Override
    public void mutate(AbstractEAIndividual individual) {
        if (individual instanceof InterfaceGAIndividual) {
            int i;
            BitSet tmpBitSet = ((InterfaceGAIndividual)((Object)individual)).getBGenotype();
            int[][] mutationIndices = new int[this.numberOfMutations][2];
            for (i = 0; i < mutationIndices.length; ++i) {
                mutationIndices[i][0] = RNG.randomInt(0, ((InterfaceGAIndividual)((Object)individual)).getGenotypeLength());
                mutationIndices[i][1] = RNG.randomInt(0, this.maxInveredBits);
            }
            for (i = 0; i < mutationIndices.length; ++i) {
                tmpBitSet.flip(mutationIndices[i][0], Math.min(((InterfaceGAIndividual)((Object)individual)).getGenotypeLength(), mutationIndices[i][0] + mutationIndices[i][1]));
                if (mutationIndices[i][0] + mutationIndices[i][1] <= ((InterfaceGAIndividual)((Object)individual)).getGenotypeLength()) continue;
                tmpBitSet.flip(0, mutationIndices[i][0] + mutationIndices[i][1] - ((InterfaceGAIndividual)((Object)individual)).getGenotypeLength());
            }
            ((InterfaceGAIndividual)((Object)individual)).setBGenotype(tmpBitSet);
        }
    }

    @Override
    public void crossoverOnStrategyParameters(AbstractEAIndividual indy1, Population partners) {
    }

    @Override
    public String getStringRepresentation() {
        return "GA inversion mutation";
    }

    public String getName() {
        return "GA invert n bits mutation";
    }

    public void setNumberOfMutations(int mutations) {
        if (mutations < 0) {
            mutations = 0;
        }
        this.numberOfMutations = mutations;
    }

    public int getNumberOfMutations() {
        return this.numberOfMutations;
    }

    public String numberOfMutationsTipText() {
        return "The number of inversion events.";
    }

    public void setMaxInveredBits(int mutations) {
        if (mutations < 0) {
            mutations = 0;
        }
        this.maxInveredBits = mutations;
    }

    public int getMaxInveredBits() {
        return this.maxInveredBits;
    }

    public String maxInveredBitsTipText() {
        return "The number of successive bits to be inverted.";
    }
}

