/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.mutation;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceGAIndividual;
import eva2.optimization.operator.mutation.InterfaceMutation;
import eva2.optimization.population.Population;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;
import java.util.BitSet;

@Description(value="Switch n bits of the GA genotype.")
public class MutateGANBit
implements InterfaceMutation,
Serializable {
    private int numberOfMutations = 1;

    public MutateGANBit() {
    }

    public MutateGANBit(MutateGANBit mutator) {
        this.numberOfMutations = mutator.numberOfMutations;
    }

    @Override
    public Object clone() {
        return new MutateGANBit(this);
    }

    @Override
    public boolean equals(Object mutator) {
        if (mutator instanceof MutateGANBit) {
            MutateGANBit mut = (MutateGANBit)mutator;
            return this.numberOfMutations == mut.numberOfMutations;
        }
        return false;
    }

    @Override
    public void initialize(AbstractEAIndividual individual, InterfaceOptimizationProblem opt) {
    }

    @Override
    public void mutate(AbstractEAIndividual individual) {
        if (individual instanceof InterfaceGAIndividual) {
            int i;
            BitSet tmpBitSet = ((InterfaceGAIndividual)((Object)individual)).getBGenotype();
            int[] mutationIndices = new int[this.numberOfMutations];
            for (i = 0; i < mutationIndices.length; ++i) {
                mutationIndices[i] = RNG.randomInt(0, ((InterfaceGAIndividual)((Object)individual)).getGenotypeLength());
            }
            for (i = 0; i < mutationIndices.length; ++i) {
                tmpBitSet.flip(mutationIndices[i]);
            }
            ((InterfaceGAIndividual)((Object)individual)).setBGenotype(tmpBitSet);
        }
    }

    @Override
    public void crossoverOnStrategyParameters(AbstractEAIndividual indy1, Population partners) {
    }

    @Override
    public String getStringRepresentation() {
        return "GA n-Bit mutation (n=" + this.numberOfMutations + ")";
    }

    public String getName() {
        return "GA n-Bit mutation";
    }

    public void setNumberOfMutations(int mutations) {
        if (mutations < 0) {
            mutations = 0;
        }
        this.numberOfMutations = mutations;
    }

    public int getNumberOfMutations() {
        return this.numberOfMutations;
    }

    public String numberOfMutationsTipText() {
        return "The number of bits to be mutated.";
    }
}

