/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.mutation;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceGAIndividual;
import eva2.optimization.operator.mutation.InterfaceMutation;
import eva2.optimization.population.Population;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;
import java.util.BitSet;

@Description(value="This mutation operator shifts n successive along the genotype (cyclic).")
public class MutateGAShiftSubstring
implements InterfaceMutation,
Serializable {
    private int subStringLength = 0;
    private int shiftDistance = 0;

    public MutateGAShiftSubstring() {
    }

    public MutateGAShiftSubstring(MutateGAShiftSubstring mutator) {
        this.subStringLength = mutator.subStringLength;
        this.shiftDistance = mutator.shiftDistance;
    }

    @Override
    public Object clone() {
        return new MutateGAShiftSubstring(this);
    }

    @Override
    public boolean equals(Object mutator) {
        if (mutator instanceof MutateGAShiftSubstring) {
            MutateGAShiftSubstring mut = (MutateGAShiftSubstring)mutator;
            if (this.subStringLength != mut.subStringLength) {
                return false;
            }
            return this.shiftDistance == mut.shiftDistance;
        }
        return false;
    }

    @Override
    public void initialize(AbstractEAIndividual individual, InterfaceOptimizationProblem opt) {
    }

    @Override
    public void mutate(AbstractEAIndividual individual) {
        if (individual instanceof InterfaceGAIndividual) {
            BitSet tmpBitSet = (BitSet)((InterfaceGAIndividual)((Object)individual)).getBGenotype().clone();
            int len = ((InterfaceGAIndividual)((Object)individual)).getGenotypeLength();
            int[] substr = this.selectSubstring(tmpBitSet, len);
            int a = substr[0];
            int b = substr[1];
            int d = this.selectShiftDist(len);
            for (int i = 0; i < b - a + 1; ++i) {
                tmpBitSet.set((len + a - d + i) % len, tmpBitSet.get((len + a + i) % len));
            }
            BitSet origBitSet = ((InterfaceGAIndividual)((Object)individual)).getBGenotype();
            for (int i = 0; i < d; ++i) {
                tmpBitSet.set((len + b - d + i + 1) % len, origBitSet.get((len + a - d + i) % len));
            }
            ((InterfaceGAIndividual)((Object)individual)).setBGenotype(tmpBitSet);
        }
    }

    private int selectShiftDist(int len) {
        if (this.shiftDistance <= 0) {
            return RNG.randomInt(len);
        }
        return this.shiftDistance;
    }

    private int[] selectSubstring(BitSet tmpBitSet, int len) {
        int[] str = new int[2];
        if (this.subStringLength <= 0) {
            str[0] = RNG.randomInt(len);
            str[1] = RNG.randomInt(len);
        } else {
            str[0] = RNG.randomInt(len);
            str[1] = this.subStringLength + str[0] - 1;
        }
        return str;
    }

    @Override
    public void crossoverOnStrategyParameters(AbstractEAIndividual indy1, Population partners) {
    }

    @Override
    public String getStringRepresentation() {
        return "GA inversion mutation";
    }

    public String getName() {
        return "GA shift bitstring mutation";
    }

    public int getSubStringLength() {
        return this.subStringLength;
    }

    public void setSubStringLength(int stringLength) {
        this.subStringLength = stringLength;
    }

    public String subStringLengthTipText() {
        return "Length of substring to shift or zero to select it at random";
    }

    public int getShiftDistance() {
        return this.shiftDistance;
    }

    public void setShiftDistance(int distance) {
        this.shiftDistance = distance;
    }

    public String shiftDistanceTipText() {
        return "Distance by which to shift (to the left) or zero to select it at random";
    }
}

