/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.mutation;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceGAIndividual;
import eva2.optimization.operator.mutation.InterfaceMutation;
import eva2.optimization.population.Population;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.EVAERROR;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;
import java.util.BitSet;

@Description(value="This mutation operator swaps bits in sub-segments of the genotype. Each segment is mutated with a certain probability. Depending on the setting, multiple mutations per segment may occur.")
public class MutateGASwapBitsSegmentwise
implements InterfaceMutation,
Serializable {
    private double mutationProbPerSegment = 0.7;
    private boolean multiplesPerSegment = false;
    private int segmentLength = 8;
    private boolean preferPairs = true;

    public MutateGASwapBitsSegmentwise() {
    }

    public MutateGASwapBitsSegmentwise(MutateGASwapBitsSegmentwise mutator) {
        this.mutationProbPerSegment = mutator.mutationProbPerSegment;
        this.setPreferTrueChange(mutator.isPreferTrueChange());
        this.multiplesPerSegment = mutator.multiplesPerSegment;
        this.segmentLength = mutator.segmentLength;
    }

    public MutateGASwapBitsSegmentwise(double p_mut, boolean multPerSeg, int segmentLen, boolean prefPairs) {
        this.mutationProbPerSegment = p_mut;
        this.multiplesPerSegment = multPerSeg;
        this.segmentLength = segmentLen;
        this.preferPairs = prefPairs;
    }

    @Override
    public Object clone() {
        return new MutateGASwapBitsSegmentwise(this);
    }

    @Override
    public boolean equals(Object mutator) {
        if (mutator instanceof MutateGASwapBitsSegmentwise) {
            MutateGASwapBitsSegmentwise mut = (MutateGASwapBitsSegmentwise)mutator;
            if (this.mutationProbPerSegment != mut.mutationProbPerSegment) {
                return false;
            }
            if (this.segmentLength != mut.segmentLength) {
                return false;
            }
            if (this.multiplesPerSegment != mut.multiplesPerSegment) {
                return false;
            }
            return this.preferPairs == mut.preferPairs;
        }
        return false;
    }

    @Override
    public void initialize(AbstractEAIndividual individual, InterfaceOptimizationProblem opt) {
    }

    @Override
    public void crossoverOnStrategyParameters(AbstractEAIndividual indy1, Population partners) {
    }

    @Override
    public void mutate(AbstractEAIndividual individual) {
        if (individual instanceof InterfaceGAIndividual) {
            BitSet tmpBitSet = ((InterfaceGAIndividual)((Object)individual)).getBGenotype();
            int genLen = ((InterfaceGAIndividual)((Object)individual)).getGenotypeLength();
            for (int i = 0; i < genLen; i += this.segmentLength) {
                if (i + this.segmentLength > genLen) {
                    EVAERROR.errorMsgOnce("Warning, genotype length is not a multiple of the segment length.. ignoring last bits in " + this.getClass());
                    break;
                }
                if (!RNG.flipCoin(this.mutationProbPerSegment)) continue;
                int cntMutes = 0;
                do {
                    this.swapBitsInSegmentAt(tmpBitSet, i, this.segmentLength);
                } while (this.multiplesPerSegment && ++cntMutes < this.segmentLength && RNG.flipCoin(this.mutationProbPerSegment));
            }
            ((InterfaceGAIndividual)((Object)individual)).setBGenotype(tmpBitSet);
        }
    }

    private void swapBitsInSegmentAt(BitSet bs, int i, int segLen) {
        int indexOne = this.getRandomIndex(bs, i, segLen, true);
        int indexTwo = this.getRandomIndex(bs, i, segLen, false);
        boolean tmpBit = bs.get(indexTwo);
        bs.set(indexTwo, bs.get(indexOne));
        bs.set(indexOne, tmpBit);
    }

    private int getRandomIndex(BitSet bs, int offset, int len, boolean maybePrefered) {
        int k = RNG.randomInt(offset, offset + len - 1);
        if (this.isPreferTrueChange()) {
            for (int maxTries = (1 + len) / 2; maybePrefered != bs.get(k) && maxTries >= 0; --maxTries) {
                k = RNG.randomInt(offset, offset + len - 1);
            }
        }
        return k;
    }

    @Override
    public String getStringRepresentation() {
        return "GA swap bits segment-wise mutation";
    }

    public String getName() {
        return "GA swap bits segment-wise mutation";
    }

    public void setPreferTrueChange(boolean preferPairs) {
        this.preferPairs = preferPairs;
    }

    public boolean isPreferTrueChange() {
        return this.preferPairs;
    }

    public String preferTrueChangeTipText() {
        return "If set to true, mutation events will prefer swapping 1 and 0";
    }

    public double getMutationProbPerSegment() {
        return this.mutationProbPerSegment;
    }

    public void setMutationProbPerSegment(double mutationProbPerSegment) {
        this.mutationProbPerSegment = mutationProbPerSegment;
    }

    public boolean isMultiplesPerSegment() {
        return this.multiplesPerSegment;
    }

    public void setMultiplesPerSegment(boolean multiplesPerSegment) {
        this.multiplesPerSegment = multiplesPerSegment;
    }

    public int getSegmentLength() {
        return this.segmentLength;
    }

    public void setSegmentLength(int segmentLength) {
        this.segmentLength = segmentLength;
    }

    public String segmentLengthTipText() {
        return "The length of sub-segments to regard (substrings of the GA genotype)";
    }
}

