/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.mutation;

import eva2.gui.editor.GenericObjectEditor;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceGAIndividual;
import eva2.optimization.operator.mutation.InterfaceMutation;
import eva2.optimization.population.Population;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.EVAERROR;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="Uniform mutation mutates every GA bit with a fixed probability.")
public class MutateGAUniform
implements InterfaceMutation,
Serializable {
    double bitwiseProb = 0.1;
    private boolean useInvertedLength = true;

    public MutateGAUniform() {
    }

    public MutateGAUniform(MutateGAUniform o) {
        this.setBitwiseProb(o.getBitwiseProb());
    }

    @Override
    public void crossoverOnStrategyParameters(AbstractEAIndividual indy1, Population partners) {
        if (indy1.getMutationOperator() instanceof MutateGAUniform) {
            MutateGAUniform mute = (MutateGAUniform)indy1.getMutationOperator();
            double smallerProb = Math.min(this.getBitwiseProb(), mute.getBitwiseProb());
            double largerProb = Math.max(this.getBitwiseProb(), mute.getBitwiseProb());
            this.setBitwiseProb(RNG.randomDouble(smallerProb, largerProb));
        }
    }

    @Override
    public Object clone() {
        return new MutateGAUniform(this);
    }

    public void hideHideable() {
        this.setUseInvertedLength(this.isUseInvertedLength());
    }

    @Override
    public String getStringRepresentation() {
        return "Uniform GA mutation (" + this.getBitwiseProb() + ")";
    }

    @Override
    public void initialize(AbstractEAIndividual individual, InterfaceOptimizationProblem opt) {
        if (this.useInvertedLength && individual instanceof InterfaceGAIndividual) {
            this.setBitwiseProb(1.0 / (double)((InterfaceGAIndividual)((Object)individual)).getGenotypeLength());
        }
    }

    @Override
    public void mutate(AbstractEAIndividual individual) {
        if (individual instanceof InterfaceGAIndividual) {
            InterfaceGAIndividual indy = (InterfaceGAIndividual)((Object)individual);
            for (int i = 0; i < indy.getGenotypeLength(); ++i) {
                if (!RNG.flipCoin(this.bitwiseProb)) continue;
                indy.getBGenotype().flip(i);
            }
        } else {
            EVAERROR.errorMsgOnce("Error: Skipped mutation since " + this.getClass() + " is applicable for InterfaceGAIndividual individuals only! (pot. multiple occ.)");
        }
    }

    public double getBitwiseProb() {
        return this.bitwiseProb;
    }

    public void setBitwiseProb(double bitwiseProb) {
        if (bitwiseProb < 0.0 && bitwiseProb > 1.0) {
            System.err.println("Warning, probability should be within [0,1], given: " + bitwiseProb);
        }
        this.bitwiseProb = bitwiseProb;
    }

    public String bitwiseProbTipText() {
        return "The probability of every bit to be flipped.";
    }

    public void setUseInvertedLength(boolean useInvertedLength) {
        this.useInvertedLength = useInvertedLength;
        GenericObjectEditor.setHideProperty(this.getClass(), "bitwiseProb", useInvertedLength);
    }

    public boolean isUseInvertedLength() {
        return this.useInvertedLength;
    }

    public String useInvertedLengthTipText() {
        return "Switch for using 1/l as mutation rate.";
    }

    public String getName() {
        return "Uniform-GA-Mutation";
    }
}

