/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.mutation;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceGIIndividual;
import eva2.optimization.operator.mutation.InterfaceMutation;
import eva2.optimization.population.Population;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="This mutation operator inserts or adds elements to the array.")
public class MutateGIInsertDelete
implements InterfaceMutation,
Serializable {
    int maxLengthOfInsDel = 2;

    public MutateGIInsertDelete() {
    }

    public MutateGIInsertDelete(MutateGIInsertDelete mutator) {
        this.maxLengthOfInsDel = mutator.maxLengthOfInsDel;
    }

    @Override
    public Object clone() {
        return new MutateGIInsertDelete();
    }

    @Override
    public boolean equals(Object mutator) {
        if (mutator instanceof MutateGIInsertDelete) {
            MutateGIInsertDelete mut = (MutateGIInsertDelete)mutator;
            return this.maxLengthOfInsDel == mut.maxLengthOfInsDel;
        }
        return false;
    }

    @Override
    public void initialize(AbstractEAIndividual individual, InterfaceOptimizationProblem opt) {
    }

    @Override
    public void crossoverOnStrategyParameters(AbstractEAIndividual indy1, Population partners) {
    }

    @Override
    public void mutate(AbstractEAIndividual individual) {
        if (individual instanceof InterfaceGIIndividual) {
            int[][] newRange;
            int[] newX;
            int[] x = ((InterfaceGIIndividual)((Object)individual)).getIGenotype();
            int[][] range = ((InterfaceGIIndividual)((Object)individual)).getIntRange();
            int length = RNG.randomInt(1, this.maxLengthOfInsDel);
            boolean insert = RNG.flipCoin(0.5);
            if (!insert && length >= x.length - 1) {
                insert = true;
            }
            if (insert) {
                int i;
                int position = RNG.randomInt(0, x.length - 1);
                newX = new int[x.length + length];
                newRange = new int[range.length + length][2];
                for (i = 0; i < position; ++i) {
                    newX[i] = x[i];
                    newRange[i] = range[i];
                }
                for (i = position; i < position + length; ++i) {
                    newX[i] = RNG.randomInt(range[position][0], range[position][1]);
                    newRange[i][0] = range[position][0];
                    newRange[i][1] = range[position][1];
                }
                for (i = position; i < x.length; ++i) {
                    newX[i + length] = x[i];
                    newRange[i + length] = range[i];
                }
            } else {
                int i;
                int position = RNG.randomInt(0, x.length - 1 - length);
                newX = new int[x.length - length];
                newRange = new int[range.length - length][2];
                if (newX.length <= 1) {
                    return;
                }
                for (i = 0; i < position; ++i) {
                    newX[i] = x[i];
                    newRange[i] = range[i];
                }
                for (i = position + length; i < x.length; ++i) {
                    newX[i - length] = x[i];
                    newRange[i - length] = range[i];
                }
            }
            if (newX.length <= 1) {
                System.out.println("newX " + newX.length);
            }
            ((InterfaceGIIndividual)((Object)individual)).setIntegerDataLength(newX.length);
            ((InterfaceGIIndividual)((Object)individual)).setIGenotype(newX);
            ((InterfaceGIIndividual)((Object)individual)).setIntRange(newRange);
            newX = ((InterfaceGIIndividual)((Object)individual)).getIGenotype();
            if (newX.length <= 1) {
                System.out.println("newX " + newX.length);
            }
        }
    }

    @Override
    public String getStringRepresentation() {
        return "GI insert/delete mutation";
    }

    public String getName() {
        return "GI insert/delete mutation";
    }

    public void setMaxLengthOfInsDel(int n) {
        this.maxLengthOfInsDel = n;
    }

    public int getMaxLengthOfInsDel() {
        return this.maxLengthOfInsDel;
    }

    public String maxLengthOfInsDelTipText() {
        return "Gives the maximum length of an inserted or deleted segment.";
    }
}

