/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.mutation;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceGIIndividual;
import eva2.optimization.operator.mutation.InterfaceMutation;
import eva2.optimization.population.Population;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="The invert mutation inverts a segment of the int[].")
public class MutateGIInvert
implements InterfaceMutation,
Serializable {
    int maxLengthOfInvert = 2;

    public MutateGIInvert() {
    }

    public MutateGIInvert(MutateGIInvert mutator) {
        this.maxLengthOfInvert = mutator.maxLengthOfInvert;
    }

    @Override
    public Object clone() {
        return new MutateGIInvert();
    }

    @Override
    public boolean equals(Object mutator) {
        if (mutator instanceof MutateGIInvert) {
            MutateGIInvert mut = (MutateGIInvert)mutator;
            return this.maxLengthOfInvert == mut.maxLengthOfInvert;
        }
        return false;
    }

    @Override
    public void initialize(AbstractEAIndividual individual, InterfaceOptimizationProblem opt) {
    }

    @Override
    public void mutate(AbstractEAIndividual individual) {
        if (individual instanceof InterfaceGIIndividual) {
            int[] x = ((InterfaceGIIndividual)((Object)individual)).getIGenotype();
            int index = 0;
            int range = RNG.randomInt(1, this.maxLengthOfInvert);
            if (2 * range >= x.length) {
                return;
            }
            int center = RNG.randomInt(range, x.length - 1 - range);
            int[] tmp = new int[x.length];
            System.arraycopy(x, 0, tmp, 0, x.length);
            for (int i = center - range; i < center + range; ++i) {
                x[center - 1 + range - index] = tmp[i];
                ++index;
            }
            ((InterfaceGIIndividual)((Object)individual)).setIGenotype(x);
        }
    }

    @Override
    public void crossoverOnStrategyParameters(AbstractEAIndividual indy1, Population partners) {
    }

    private void pintInt(String s, int[] x) {
        String tmp = "{" + x[0];
        for (int i = 1; i < x.length; ++i) {
            tmp = tmp + ", " + x[i];
        }
        System.out.println(s + tmp + "}");
    }

    @Override
    public String getStringRepresentation() {
        return "GI invert mutation";
    }

    public String getName() {
        return "GI invert mutation";
    }

    public void setMaxLengthOfInvert(int n) {
        this.maxLengthOfInvert = n;
    }

    public int getMaxLengthOfInvert() {
        return this.maxLengthOfInvert;
    }

    public String maxLengthOfInvertTipText() {
        return "Gives half the maximum length of an inverted segment.";
    }
}

