/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.mutation;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceGIIndividual;
import eva2.optimization.operator.mutation.InterfaceMutation;
import eva2.optimization.population.Population;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="The nominal mutation alters n element of the int attributes completely at random.")
public class MutateGINominal
implements InterfaceMutation,
Serializable {
    int numberOfMutations = 2;

    public MutateGINominal() {
    }

    public MutateGINominal(MutateGINominal mutator) {
        this.numberOfMutations = mutator.numberOfMutations;
    }

    @Override
    public Object clone() {
        return new MutateGINominal();
    }

    @Override
    public boolean equals(Object mutator) {
        if (mutator instanceof MutateGINominal) {
            MutateGINominal mut = (MutateGINominal)mutator;
            return this.numberOfMutations == mut.numberOfMutations;
        }
        return false;
    }

    @Override
    public void initialize(AbstractEAIndividual individual, InterfaceOptimizationProblem opt) {
    }

    @Override
    public void mutate(AbstractEAIndividual individual) {
        if (individual instanceof InterfaceGIIndividual) {
            int[] x = ((InterfaceGIIndividual)((Object)individual)).getIGenotype();
            int[][] range = ((InterfaceGIIndividual)((Object)individual)).getIntRange();
            int mutInd = 0;
            for (int k = 0; k < this.numberOfMutations; ++k) {
                try {
                    mutInd = RNG.randomInt(0, x.length - 1);
                }
                catch (ArithmeticException e) {
                    System.out.println("x.length " + x.length);
                }
                x[mutInd] = RNG.randomInt(range[mutInd][0], range[mutInd][1]);
            }
            ((InterfaceGIIndividual)((Object)individual)).setIGenotype(x);
        }
    }

    @Override
    public void crossoverOnStrategyParameters(AbstractEAIndividual indy1, Population partners) {
    }

    @Override
    public String getStringRepresentation() {
        return "GI nominal mutation";
    }

    public String getName() {
        return "GI nominal mutation";
    }

    public void setNumberOfMutations(int n) {
        this.numberOfMutations = n;
    }

    public int getNumberOfMutations() {
        return this.numberOfMutations;
    }

    public String numberOfMutationsTipText() {
        return "Gives the number of mutations.";
    }
}

