/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.mutation;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceGIIndividual;
import eva2.optimization.operator.mutation.InterfaceMutation;
import eva2.optimization.population.Population;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="The ordinal mutation alters n element of the int attributes based on an ordinal ordering.")
public class MutateGIOrdinal
implements InterfaceMutation,
Serializable {
    double stepSize = 0.1;
    int numberOfMutations = 2;

    public MutateGIOrdinal() {
    }

    public MutateGIOrdinal(MutateGIOrdinal mutator) {
        this.stepSize = mutator.stepSize;
        this.numberOfMutations = mutator.numberOfMutations;
    }

    @Override
    public Object clone() {
        return new MutateGIOrdinal();
    }

    @Override
    public boolean equals(Object mutator) {
        if (mutator instanceof MutateGIOrdinal) {
            MutateGIOrdinal mut = (MutateGIOrdinal)mutator;
            if (this.stepSize != mut.stepSize) {
                return false;
            }
            return this.numberOfMutations == mut.numberOfMutations;
        }
        return false;
    }

    @Override
    public void initialize(AbstractEAIndividual individual, InterfaceOptimizationProblem opt) {
    }

    @Override
    public void mutate(AbstractEAIndividual individual) {
        if (individual instanceof InterfaceGIIndividual) {
            int[] x = ((InterfaceGIIndividual)((Object)individual)).getIGenotype();
            int[][] range = ((InterfaceGIIndividual)((Object)individual)).getIntRange();
            for (int k = 0; k < this.numberOfMutations; ++k) {
                int mutInd = RNG.randomInt(0, x.length - 1);
                double mutate = RNG.gaussianDouble(this.stepSize);
                int mut = (int)Math.round(mutate *= 0.0);
                if (mut == 0) {
                    mut = RNG.flipCoin(0.5) ? -1 : 1;
                }
                int n = mutInd;
                x[n] = x[n] + mut;
                if (x[mutInd] < range[mutInd][0]) {
                    x[mutInd] = range[mutInd][0];
                }
                if (x[mutInd] <= range[mutInd][1]) continue;
                x[mutInd] = range[mutInd][1];
            }
            ((InterfaceGIIndividual)((Object)individual)).setIGenotype(x);
        }
    }

    @Override
    public void crossoverOnStrategyParameters(AbstractEAIndividual indy1, Population partners) {
    }

    @Override
    public String getStringRepresentation() {
        return "GI ordinal mutation";
    }

    public String getName() {
        return "GI ordinal mutation";
    }

    public void setStepSize(double n) {
        this.stepSize = n;
    }

    public double getStepSize() {
        return this.stepSize;
    }

    public String stepSizeTipText() {
        return "Gives the mean step size on a normalized search space.";
    }

    public void setNumberOfMutations(int n) {
        this.numberOfMutations = n;
    }

    public int getNumberOfMutations() {
        return this.numberOfMutations;
    }

    public String numberOfMutationsTipText() {
        return "Gives the number of mutations.";
    }
}

