/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.mutation;

import eva2.gui.BeanInspector;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceGIIndividual;
import eva2.optimization.operator.mutation.InterfaceMutation;
import eva2.optimization.population.Population;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.EVAERROR;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="A mutation operator which switches positions within a given subset only. A random position is chosen but mutated only if its allele is contained in the mutable set. The new allele is chosen from this set as well. In case the random positions do not contain a mutable allele, the switching is skipped. This means that fewer switches may occur than expected from the minimal bound.")
public class MutateGISubset
implements InterfaceMutation,
Serializable {
    private int[] mutableSet = new int[]{0, 1};
    private int minNumMutations = 1;
    private int maxNumMutations = 3;
    private boolean enforceMutablePositions = true;

    public MutateGISubset() {
    }

    public MutateGISubset(MutateGISubset o) {
        this.minNumMutations = o.minNumMutations;
        this.maxNumMutations = o.maxNumMutations;
        this.enforceMutablePositions = o.enforceMutablePositions;
        if (o.mutableSet != null) {
            this.mutableSet = new int[o.mutableSet.length];
            System.arraycopy(o.mutableSet, 0, this.mutableSet, 0, o.mutableSet.length);
        }
    }

    public MutateGISubset(int[] muteSet, int minMutes, int maxMutes) {
        this.setMutableSet(muteSet);
        this.setMinNumMutations(minMutes);
        this.setMaxNumMutations(maxMutes);
    }

    @Override
    public Object clone() {
        return new MutateGISubset(this);
    }

    @Override
    public void crossoverOnStrategyParameters(AbstractEAIndividual indy1, Population partners) {
    }

    @Override
    public String getStringRepresentation() {
        return "GI subset mutation in " + BeanInspector.toString(this.mutableSet);
    }

    @Override
    public void initialize(AbstractEAIndividual individual, InterfaceOptimizationProblem opt) {
    }

    @Override
    public void mutate(AbstractEAIndividual individual) {
        if (individual instanceof InterfaceGIIndividual) {
            InterfaceGIIndividual giIndy = (InterfaceGIIndividual)((Object)individual);
            int[] genotype = giIndy.getIGenotype();
            int[][] range = giIndy.getIntRange();
            int numMutes = RNG.randomInt(this.minNumMutations, this.maxNumMutations);
            for (int i = 0; i < numMutes; ++i) {
                this.maybePerformSingleMutation(genotype, range, genotype.length / numMutes);
            }
        }
    }

    private void maybePerformSingleMutation(int[] genotype, int[][] range, int maxTries) {
        int index = RNG.randomInt(genotype.length);
        if (this.enforceMutablePositions && !this.isMutable(genotype[index])) {
            do {
                index = RNG.randomInt(genotype.length);
            } while (--maxTries > 0 && !this.isMutable(genotype[index]));
        }
        if (this.isMutable(genotype[index])) {
            genotype[index] = this.randomValidElement(range, index, genotype[index]);
        }
    }

    private int randomValidElement(int[][] range, int index, int oldVal) {
        int v = this.mutableSet[RNG.randomInt(this.mutableSet.length)];
        if (v >= range[index][0] && v <= range[index][1]) {
            return v;
        }
        EVAERROR.errorMsgOnce("Warning, mutation subset violates range definition!");
        return oldVal;
    }

    private boolean isMutable(int v) {
        for (int i = 0; i < this.mutableSet.length; ++i) {
            if (this.mutableSet[i] != v) continue;
            return true;
        }
        return false;
    }

    public int[] getMutableSet() {
        return this.mutableSet;
    }

    public void setMutableSet(int[] mutationSubset) {
        this.mutableSet = mutationSubset;
    }

    public String mutableSetTipText() {
        return "A subset of integers among which mutations may occur.";
    }

    public int getMinNumMutations() {
        return this.minNumMutations;
    }

    public void setMinNumMutations(int minNumMutations) {
        this.minNumMutations = minNumMutations;
    }

    public String minNumMutationsTipText() {
        return "A lower bound for the number of positions changed per mutation event";
    }

    public int getMaxNumMutations() {
        return this.maxNumMutations;
    }

    public void setMaxNumMutations(int maxNumMutations) {
        this.maxNumMutations = maxNumMutations;
    }

    public String maxNumMutationsTipText() {
        return "An upper bound for the number of positions changed per mutation event";
    }

    public boolean isEnforceMutablePositions() {
        return this.enforceMutablePositions;
    }

    public void setEnforceMutablePositions(boolean enforceMutablePositions) {
        this.enforceMutablePositions = enforceMutablePositions;
    }

    public String enforceMutablePositionsTipText() {
        return "If true, the probability to hit a mutable position in a mutation event is increased by trying multiple times.";
    }
}

