/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.mutation;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceGIIndividual;
import eva2.optimization.operator.mutation.InterfaceMutation;
import eva2.optimization.population.Population;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="This mutation translocates a segment of the int[].")
public class MutateGITranslocate
implements InterfaceMutation,
Serializable {
    int maxLengthOfTranslocate = 4;
    int maxTransLocDistance = -1;

    public MutateGITranslocate() {
    }

    public MutateGITranslocate(int maxTranslLen) {
        this();
        this.setMaxLengthOfTranslocate(maxTranslLen);
    }

    public MutateGITranslocate(int maxTranslLen, int maxTransDist) {
        this();
        this.setMaxLengthOfTranslocate(maxTranslLen);
        this.setMaxTranslocationDist(maxTransDist);
    }

    public MutateGITranslocate(MutateGITranslocate mutator) {
        this.maxLengthOfTranslocate = mutator.maxLengthOfTranslocate;
    }

    @Override
    public Object clone() {
        return new MutateGITranslocate();
    }

    @Override
    public boolean equals(Object mutator) {
        if (mutator instanceof MutateGITranslocate) {
            MutateGITranslocate mut = (MutateGITranslocate)mutator;
            return this.maxLengthOfTranslocate == mut.maxLengthOfTranslocate;
        }
        return false;
    }

    @Override
    public void initialize(AbstractEAIndividual individual, InterfaceOptimizationProblem opt) {
    }

    @Override
    public void mutate(AbstractEAIndividual individual) {
        if (individual instanceof InterfaceGIIndividual) {
            int to;
            int length;
            int[] x = ((InterfaceGIIndividual)((Object)individual)).getIGenotype();
            if (x.length < (length = RNG.randomInt(1, this.maxLengthOfTranslocate)) + 2) {
                return;
            }
            int from = RNG.randomInt(0, x.length - 1 - length);
            if (this.maxTransLocDistance <= 0) {
                to = RNG.randomInt(0, x.length - 1 - length);
            } else {
                int minTo = Math.max(0, from - this.maxTransLocDistance);
                int maxTo = Math.min(x.length - 1 - length, from + this.maxTransLocDistance);
                to = RNG.randomInt(minTo, maxTo);
            }
            int[] tmp = new int[x.length];
            int[] without = new int[x.length - length];
            int[] insert = new int[length];
            System.arraycopy(x, from, insert, 0, length);
            for (int i = 0; i < without.length; ++i) {
                without[i] = i < from ? x[i] : x[i + length];
            }
            System.arraycopy(without, 0, tmp, 0, to);
            System.arraycopy(insert, 0, tmp, to, to + length - to);
            System.arraycopy(without, to + length - length, tmp, to + length, x.length - (to + length));
            ((InterfaceGIIndividual)((Object)individual)).setIGenotype(tmp);
        }
    }

    @Override
    public void crossoverOnStrategyParameters(AbstractEAIndividual indy1, Population partners) {
    }

    @Override
    public String getStringRepresentation() {
        return "GI translocation mutation";
    }

    public String getName() {
        return "GI translocation mutation";
    }

    public void setMaxLengthOfTranslocate(int n) {
        this.maxLengthOfTranslocate = n;
    }

    public int getMaxLengthOfTranslocate() {
        return this.maxLengthOfTranslocate;
    }

    public String maxLengthOfTranslocateTipText() {
        return "Gives the maximum length of the translocated segment.";
    }

    public void setMaxTranslocationDist(int n) {
        this.maxTransLocDistance = n;
    }

    public int getMaxTranslocationDist() {
        return this.maxTransLocDistance;
    }

    public String maxTranslocationDistTipText() {
        return "Gives the maximum distance by which a segment may be translocated.";
    }
}

