/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.mutation;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceGPIndividual;
import eva2.optimization.operator.mutation.InterfaceMutation;
import eva2.optimization.population.Population;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="This mutation replaces a random node with a new random subtree.")
public class MutateGPAdaptive
implements InterfaceMutation,
Serializable {
    protected double mutationStep = 1.0;
    protected double tau1 = 0.15;
    protected double tau2 = 0.15;
    protected double lowerLimitStepSize = 5.0E-7;

    public MutateGPAdaptive() {
    }

    public MutateGPAdaptive(MutateGPAdaptive mutator) {
        this.mutationStep = mutator.mutationStep;
        this.tau1 = mutator.tau1;
        this.tau2 = mutator.tau2;
        this.lowerLimitStepSize = mutator.lowerLimitStepSize;
    }

    @Override
    public Object clone() {
        return new MutateGPAdaptive(this);
    }

    @Override
    public boolean equals(Object mutator) {
        if (mutator instanceof MutateGPAdaptive) {
            MutateGPAdaptive mut = (MutateGPAdaptive)mutator;
            if (this.mutationStep != mut.mutationStep) {
                return false;
            }
            if (this.tau1 != mut.tau1) {
                return false;
            }
            if (this.tau2 != mut.tau2) {
                return false;
            }
            return this.lowerLimitStepSize == mut.lowerLimitStepSize;
        }
        return false;
    }

    @Override
    public void initialize(AbstractEAIndividual individual, InterfaceOptimizationProblem opt) {
    }

    @Override
    public void mutate(AbstractEAIndividual individual) {
        if (individual instanceof InterfaceGPIndividual) {
            this.mutationStep *= Math.exp(this.tau1 * RNG.gaussianDouble(1.0) + this.tau2 * RNG.gaussianDouble(1.0));
            if (this.mutationStep < this.lowerLimitStepSize) {
                this.mutationStep = this.lowerLimitStepSize;
            }
            if (this.mutationStep > 1.0) {
                this.mutationStep = 1.0;
            }
            if (RNG.flipCoin(this.mutationStep)) {
                individual.defaultMutate();
            }
        }
    }

    @Override
    public void crossoverOnStrategyParameters(AbstractEAIndividual indy1, Population partners) {
    }

    @Override
    public String getStringRepresentation() {
        return "GP adaptive mutation";
    }

    public String getName() {
        return "GP adaptive mutation";
    }

    public void setMutationStep(double d) {
        if (d < 0.0) {
            d = this.lowerLimitStepSize;
        }
        this.mutationStep = d;
    }

    public double getMutationStepSize() {
        return this.mutationStep;
    }

    public String mutationStepSizeTipText() {
        return "Choose the initial mutation step size.";
    }

    public void setLowerLimitStepSize(double d) {
        if (d < 0.0) {
            d = 0.0;
        }
        this.lowerLimitStepSize = d;
    }

    public double getLowerLimitStepSize() {
        return this.lowerLimitStepSize;
    }

    public String lowerLimitStepSizeTipText() {
        return "Set the lower limit for the mutation step size.";
    }

    public void setTau1(double d) {
        if (d < 0.0) {
            d = 0.0;
        }
        this.tau1 = d;
    }

    public double getTau1() {
        return this.tau1;
    }

    public String tau1TipText() {
        return "Set the value for tau1.";
    }

    public void setTau2(double d) {
        if (d < 0.0) {
            d = 0.0;
        }
        this.tau2 = d;
    }

    public double getTau2() {
        return this.tau2;
    }

    public String tau2TipText() {
        return "Set the value for tau2.";
    }
}

