/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.mutation;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceGPIndividual;
import eva2.optimization.individuals.codings.gp.AbstractGPNode;
import eva2.optimization.individuals.codings.gp.GPArea;
import eva2.optimization.operator.mutation.InterfaceMutation;
import eva2.optimization.population.Population;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;
import java.util.ArrayList;

@Description(value="The node mutation replaces a random node but keeps the descendants.")
public class MutateGPSingleNode
implements InterfaceMutation,
Serializable {
    @Override
    public Object clone() {
        return new MutateGPSingleNode();
    }

    @Override
    public boolean equals(Object mutator) {
        return mutator instanceof MutateGPSingleNode;
    }

    @Override
    public void initialize(AbstractEAIndividual individual, InterfaceOptimizationProblem opt) {
    }

    @Override
    public void mutate(AbstractEAIndividual individual) {
        if (individual instanceof InterfaceGPIndividual) {
            ArrayList allNodes = new ArrayList();
            AbstractGPNode[] programs = ((InterfaceGPIndividual)((Object)individual)).getPGenotype();
            GPArea[] areas = (GPArea[])((InterfaceGPIndividual)((Object)individual)).getFunctionArea();
            for (int i = 0; i < programs.length; ++i) {
                programs[i].addNodesTo(allNodes);
                AbstractGPNode nodeToMutate = (AbstractGPNode)allNodes.get(RNG.randomInt(0, allNodes.size() - 1));
                int orgArity = nodeToMutate.getArity();
                AbstractGPNode newNode = (AbstractGPNode)areas[i].getRandomNodeWithArity(orgArity).clone();
                AbstractGPNode parent = nodeToMutate.getParent();
                if (parent != null) {
                    newNode.setParent(parent);
                } else {
                    ((InterfaceGPIndividual)((Object)individual)).setPGenotype(newNode, i);
                }
                newNode.initNodeArray();
                for (int j = 0; j < nodeToMutate.getArity(); ++j) {
                    if (nodeToMutate.getNode(j) == null) {
                        System.out.println("j" + j);
                    }
                    newNode.setNode(nodeToMutate.getNode(j), j);
                }
            }
        }
    }

    @Override
    public void crossoverOnStrategyParameters(AbstractEAIndividual indy1, Population partners) {
    }

    @Override
    public String getStringRepresentation() {
        return "GP node mutation";
    }

    public String getName() {
        return "GP node mutation";
    }
}

