/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.mutation;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceOBGAIndividual;
import eva2.optimization.operator.mutation.InterfaceMutation;
import eva2.optimization.population.Population;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="This mutation operators flips edges of the OBGA.")
public class MutateOBGAFlip
implements InterfaceMutation,
Serializable {
    int times = 2;

    @Override
    public Object clone() {
        return this;
    }

    @Override
    public boolean equals(Object mutator) {
        return mutator instanceof MutateOBGAFlip;
    }

    @Override
    public void initialize(AbstractEAIndividual individual, InterfaceOptimizationProblem opt) {
    }

    @Override
    public void mutate(AbstractEAIndividual individual) {
        int[][] perm = ((InterfaceOBGAIndividual)((Object)individual)).getOBGenotype();
        for (int p = 0; p < perm.length; ++p) {
            for (int i = 0; i < this.times; ++i) {
                int p1 = RNG.randomInt(0, perm[p].length - 1);
                int p2 = RNG.randomInt(0, perm[p].length - 1);
                int temp = perm[p][p1];
                perm[p][p1] = perm[p][p2];
                perm[p][p2] = temp;
            }
        }
        ((InterfaceOBGAIndividual)((Object)individual)).setOBGenotype(perm);
    }

    @Override
    public void crossoverOnStrategyParameters(AbstractEAIndividual indy1, Population partners) {
    }

    @Override
    public String getStringRepresentation() {
        return "OBGA flip mutation";
    }

    public String getName() {
        return "OBGA flip mutation";
    }

    public int getTimes() {
        return this.times;
    }

    public void setTimes(int times) {
        this.times = times;
    }
}

