/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.mutation;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceDataTypePermutation;
import eva2.optimization.individuals.InterfaceOBGAIndividual;
import eva2.optimization.operator.mutation.InterfaceMutation;
import eva2.optimization.population.Population;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="This mutation operators inverts a certain section of the OBGA.")
public class MutateOBGAInversion
implements Serializable,
InterfaceMutation {
    @Override
    public Object clone() {
        return this;
    }

    @Override
    public boolean equals(Object mutator) {
        return mutator instanceof MutateOBGAInversion;
    }

    @Override
    public void initialize(AbstractEAIndividual individual, InterfaceOptimizationProblem opt) {
    }

    @Override
    public void mutate(AbstractEAIndividual individual) {
        int[][] permnew = (int[][])((InterfaceOBGAIndividual)((Object)individual)).getOBGenotype().clone();
        int[][] perm = ((InterfaceDataTypePermutation)((Object)individual)).getPermutationData();
        for (int p = 0; p < perm.length; ++p) {
            int p1 = RNG.randomInt(0, perm[p].length - 1);
            int p2 = RNG.randomInt(p1, perm[p].length - 1);
            for (int i = 0; i <= p2 - p1; ++i) {
                permnew[p][p1 + i] = perm[p][p2 - i];
            }
        }
        ((InterfaceOBGAIndividual)((Object)individual)).setOBGenotype(permnew);
    }

    @Override
    public void crossoverOnStrategyParameters(AbstractEAIndividual indy1, Population partners) {
    }

    @Override
    public String getStringRepresentation() {
        return "OBGA inversion mutation";
    }

    public String getName() {
        return "OBGA inversion mutation";
    }
}

