/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.mutation;

import eva2.gui.PropertyEditorProvider;
import eva2.gui.editor.GenericObjectEditor;
import eva2.optimization.operator.mutation.InterfaceMutation;
import eva2.optimization.operator.mutation.PropertyMutationMixer;
import eva2.optimization.tools.AbstractObjectEditor;
import eva2.optimization.tools.GeneralGEOFaker;
import eva2.optimization.tools.GeneralOptimizationEditorProperty;
import eva2.tools.BasicResourceLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class PropertyMutationMixerEditor
extends JPanel
implements PropertyEditor,
PropertyChangeListener {
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private JLabel label = new JLabel("Can't edit", 0);
    private PropertyMutationMixer mutatorsWithWeights;
    private JComponent editorComponent;
    private JPanel targetListPanel;
    private JTextField[] weights;
    private JComponent[] targets;
    private JButton[] deleteButtons;
    private JScrollPane scrolltargetPanel;
    private GeneralOptimizationEditorProperty[] editors;
    private GeneralGEOFaker component;
    private PropertyChangeListener self;
    ActionListener updateTargets = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            PropertyMutationMixerEditor.this.updateTargetList();
        }
    };
    ActionListener addTarget = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            PropertyMutationMixerEditor.this.mutatorsWithWeights.addMutator((InterfaceMutation)PropertyMutationMixerEditor.this.mutatorsWithWeights.getAvailableMutators()[0].clone());
            int l = PropertyMutationMixerEditor.this.mutatorsWithWeights.getSelectedMutators().length;
            GeneralOptimizationEditorProperty[] newEdit = new GeneralOptimizationEditorProperty[l];
            System.arraycopy(PropertyMutationMixerEditor.this.editors, 0, newEdit, 0, PropertyMutationMixerEditor.this.editors.length);
            InterfaceMutation[] list = PropertyMutationMixerEditor.this.mutatorsWithWeights.getSelectedMutators();
            newEdit[--l] = new GeneralOptimizationEditorProperty();
            newEdit[l].name = list[l].getStringRepresentation();
            try {
                newEdit[l].value = list[l];
                newEdit[l].editor = PropertyEditorProvider.findEditor(newEdit[l].value.getClass());
                if (newEdit[l].editor == null) {
                    newEdit[l].editor = PropertyEditorProvider.findEditor(InterfaceMutation.class);
                }
                if (newEdit[l].editor instanceof GenericObjectEditor) {
                    ((GenericObjectEditor)newEdit[l].editor).setClassType(InterfaceMutation.class);
                }
                newEdit[l].editor.setValue(newEdit[l].value);
                newEdit[l].editor.addPropertyChangeListener(PropertyMutationMixerEditor.this.self);
                AbstractObjectEditor.findViewFor(newEdit[l]);
                if (newEdit[l].view != null) {
                    newEdit[l].view.repaint();
                }
            }
            catch (Exception e) {
                System.out.println("Darn can't read the value...");
            }
            PropertyMutationMixerEditor.access$202(PropertyMutationMixerEditor.this, newEdit);
            PropertyMutationMixerEditor.this.updateTargetList();
        }
    };
    ActionListener deleteTarget = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            int l = PropertyMutationMixerEditor.this.mutatorsWithWeights.getSelectedMutators().length;
            int j = 0;
            GeneralOptimizationEditorProperty[] newEdit = new GeneralOptimizationEditorProperty[l - 1];
            for (int i = 0; i < PropertyMutationMixerEditor.this.deleteButtons.length; ++i) {
                if (event.getSource().equals(PropertyMutationMixerEditor.this.deleteButtons[i])) {
                    PropertyMutationMixerEditor.this.mutatorsWithWeights.removeMutator(i);
                    continue;
                }
                newEdit[j] = PropertyMutationMixerEditor.this.editors[i];
                ++j;
            }
            PropertyMutationMixerEditor.access$202(PropertyMutationMixerEditor.this, newEdit);
            PropertyMutationMixerEditor.this.updateTargetList();
        }
    };
    ActionListener normalizeWeights = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            PropertyMutationMixerEditor.this.mutatorsWithWeights.normalizeWeights();
            PropertyMutationMixerEditor.this.updateTargetList();
        }
    };
    KeyListener readDoubleArrayAction = new KeyListener(){

        @Override
        public void keyPressed(KeyEvent event) {
        }

        @Override
        public void keyTyped(KeyEvent event) {
        }

        @Override
        public void keyReleased(KeyEvent event) {
            double[] newW = PropertyMutationMixerEditor.this.mutatorsWithWeights.getWeights();
            for (int i = 0; i < newW.length; ++i) {
                try {
                    double d = 0.0;
                    newW[i] = d = Double.parseDouble(PropertyMutationMixerEditor.this.weights[i].getText());
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            PropertyMutationMixerEditor.this.mutatorsWithWeights.setWeights(newW);
        }
    };

    public PropertyMutationMixerEditor() {
        this.self = this;
    }

    private void initCustomEditor() {
        this.self = this;
        this.editorComponent = new JPanel();
        this.editorComponent.setPreferredSize(new Dimension(450, 200));
        this.editorComponent.setMinimumSize(new Dimension(450, 200));
        InterfaceMutation[] list = this.mutatorsWithWeights.getSelectedMutators();
        this.editors = new GeneralOptimizationEditorProperty[list.length];
        for (int i = 0; i < list.length; ++i) {
            this.editors[i] = new GeneralOptimizationEditorProperty();
            this.editors[i].name = list[i].getStringRepresentation();
            try {
                this.editors[i].value = list[i];
                this.editors[i].editor = PropertyEditorProvider.findEditor(this.editors[i].value.getClass());
                if (this.editors[i].editor == null) {
                    this.editors[i].editor = PropertyEditorProvider.findEditor(InterfaceMutation.class);
                }
                if (this.editors[i].editor instanceof GenericObjectEditor) {
                    ((GenericObjectEditor)this.editors[i].editor).setClassType(InterfaceMutation.class);
                }
                this.editors[i].editor.setValue(this.editors[i].value);
                this.editors[i].editor.addPropertyChangeListener(this);
                AbstractObjectEditor.findViewFor(this.editors[i]);
                if (this.editors[i].view == null) continue;
                this.editors[i].view.repaint();
                continue;
            }
            catch (Exception e) {
                System.out.println("Darn can't read the value...");
            }
        }
        this.targetListPanel = new JPanel();
        this.updateTargetList();
        this.scrolltargetPanel = new JScrollPane(this.targetListPanel);
        this.editorComponent.setLayout(new BorderLayout());
        this.editorComponent.add((Component)this.scrolltargetPanel, "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 2));
        JButton addButton = new JButton("Add Mutator");
        JButton normButton = new JButton("Normalize Propabilities");
        normButton.setEnabled(true);
        normButton.addActionListener(this.normalizeWeights);
        addButton.addActionListener(this.addTarget);
        buttonPanel.add(normButton);
        buttonPanel.add(addButton);
        this.editorComponent.add((Component)buttonPanel, "South");
        JTextArea jt = new JTextArea();
        jt.setFont(new Font("SansSerif", 0, 12));
        jt.setEditable(false);
        jt.setLineWrap(true);
        jt.setWrapStyleWord(true);
        jt.setText(this.mutatorsWithWeights.getDescriptiveString());
        jt.setBackground(this.getBackground());
        JPanel jp = new JPanel();
        jp.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Info"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        jp.setLayout(new BorderLayout());
        jp.add((Component)jt, "Center");
        JPanel p2 = new JPanel();
        p2.setLayout(new BorderLayout());
        JButton help = new JButton("Help");
        help.setEnabled(false);
        p2.add((Component)help, "North");
        jp.add((Component)p2, "East");
        GridBagConstraints gbConstraints = new GridBagConstraints();
        this.editorComponent.add((Component)jp, "North");
        this.updateEditor();
    }

    private void updateTargetList() {
        int i;
        BasicResourceLoader loader = BasicResourceLoader.getInstance();
        InterfaceMutation[] list = this.mutatorsWithWeights.getSelectedMutators();
        double[] weights = this.mutatorsWithWeights.getWeights();
        this.targetListPanel.removeAll();
        this.targetListPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        this.weights = new JTextField[list.length];
        this.targets = new JComponent[list.length];
        this.deleteButtons = new JButton[list.length];
        String[] cups = new String[8];
        for (i = 0; i < cups.length; ++i) {
            cups[i] = "" + (i + 1);
        }
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.weightx = 2.0;
        this.targetListPanel.add((Component)new JLabel(this.mutatorsWithWeights.getWeigthsLabel()), gbc);
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.gridx = 1;
        gbc.weightx = 10.0;
        this.targetListPanel.add((Component)new JLabel("Target"), gbc);
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.gridx = 2;
        gbc.weightx = 1.0;
        this.targetListPanel.add((Component)new JLabel("Remove"), gbc);
        for (i = 0; i < list.length; ++i) {
            gbc.anchor = 17;
            gbc.fill = 1;
            gbc.gridx = 0;
            gbc.weightx = 2.0;
            this.weights[i] = new JTextField("" + weights[i]);
            this.weights[i].addKeyListener(this.readDoubleArrayAction);
            this.targetListPanel.add((Component)this.weights[i], gbc);
            gbc.anchor = 17;
            gbc.fill = 1;
            gbc.gridx = 1;
            gbc.weightx = 10.0;
            this.targets[i] = this.editors[i].view;
            this.targetListPanel.add((Component)this.targets[i], gbc);
            gbc.anchor = 17;
            gbc.fill = 0;
            gbc.gridx = 2;
            gbc.weightx = 1.0;
            byte[] bytes = loader.getBytesFromResourceLocation("images/Sub24.gif", true);
            this.deleteButtons[i] = new JButton("", new ImageIcon(Toolkit.getDefaultToolkit().createImage(bytes)));
            this.deleteButtons[i].addActionListener(this.deleteTarget);
            this.targetListPanel.add((Component)this.deleteButtons[i], gbc);
        }
        this.targetListPanel.repaint();
        this.targetListPanel.validate();
        if (this.scrolltargetPanel != null) {
            this.scrolltargetPanel.validate();
            this.scrolltargetPanel.repaint();
        }
        if (this.editorComponent != null) {
            this.editorComponent.validate();
            this.editorComponent.repaint();
        }
    }

    private void updateEditor() {
        if (this.editorComponent != null) {
            this.targetListPanel.validate();
            this.targetListPanel.repaint();
            this.scrolltargetPanel.validate();
            this.scrolltargetPanel.repaint();
            this.editorComponent.validate();
            this.editorComponent.repaint();
        }
    }

    @Override
    public void setValue(Object o) {
        if (o instanceof PropertyMutationMixer) {
            this.mutatorsWithWeights = (PropertyMutationMixer)o;
            this.updateEditor();
        }
    }

    @Override
    public Object getValue() {
        return this.mutatorsWithWeights;
    }

    @Override
    public String getJavaInitializationString() {
        return "TEST";
    }

    @Override
    public String getAsText() {
        return null;
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        throw new IllegalArgumentException(text);
    }

    @Override
    public String[] getTags() {
        return null;
    }

    public void addOkListener(ActionListener a) {
    }

    public void removeOkListener(ActionListener a) {
    }

    @Override
    public boolean isPaintable() {
        return true;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
        FontMetrics fm = gfx.getFontMetrics();
        int vpad = (box.height - fm.getAscent()) / 2;
        String rep = "Mixed Mutators";
        gfx.drawString(rep, 2, fm.getHeight() + vpad - 3);
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        if (this.component == null) {
            this.initCustomEditor();
            this.component = new GeneralGEOFaker(this, (JPanel)this.editorComponent);
        }
        return this.component;
    }

    public void updateCenterComponent(PropertyChangeEvent evt) {
        this.updateEditor();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object newVal = evt.getNewValue();
        Object oldVal = evt.getOldValue();
        InterfaceMutation[] list = this.mutatorsWithWeights.getSelectedMutators();
        for (int i = 0; i < list.length; ++i) {
            if (!oldVal.equals(list[i])) continue;
            list[i] = (InterfaceMutation)newVal;
            this.editors[i].name = list[i].getStringRepresentation();
            try {
                this.editors[i].value = list[i];
                this.editors[i].editor = PropertyEditorProvider.findEditor(this.editors[i].value.getClass());
                if (this.editors[i].editor == null) {
                    this.editors[i].editor = PropertyEditorProvider.findEditor(InterfaceMutation.class);
                }
                if (this.editors[i].editor instanceof GenericObjectEditor) {
                    ((GenericObjectEditor)this.editors[i].editor).setClassType(InterfaceMutation.class);
                }
                this.editors[i].editor.setValue(this.editors[i].value);
                this.editors[i].editor.addPropertyChangeListener(this);
                AbstractObjectEditor.findViewFor(this.editors[i]);
                if (this.editors[i].view != null) {
                    this.editors[i].view.repaint();
                }
            }
            catch (Exception e) {
                System.out.println("Darn can't read the value...");
            }
            this.targets[i] = this.editors[i].view;
            i = list.length;
        }
        this.updateCenterComponent(evt);
        this.propertyChangeSupport.firePropertyChange("", this.mutatorsWithWeights, this.mutatorsWithWeights);
    }

    static /* synthetic */ GeneralOptimizationEditorProperty[] access$202(PropertyMutationMixerEditor x0, GeneralOptimizationEditorProperty[] x1) {
        x0.editors = x1;
        return x1;
    }
}

