/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.nichepso.absorption;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.nichepso.absorption.StandardAbsorptionStrategy;
import eva2.optimization.strategies.ParticleSubSwarmOptimization;

public class EuclideanDiversityAbsorptionStrategy
extends StandardAbsorptionStrategy {
    private double epsilon = 0.1;

    public EuclideanDiversityAbsorptionStrategy() {
    }

    public EuclideanDiversityAbsorptionStrategy(EuclideanDiversityAbsorptionStrategy other) {
        this.epsilon = other.epsilon;
    }

    public EuclideanDiversityAbsorptionStrategy(double eps) {
        this.epsilon = eps;
    }

    @Override
    public boolean shouldAbsorbParticleIntoSubswarm(AbstractEAIndividual indy, ParticleSubSwarmOptimization subswarm, ParticleSubSwarmOptimization mainswarm) {
        if (!super.shouldAbsorbParticleIntoSubswarm(indy, subswarm, mainswarm)) {
            return false;
        }
        return this.diversityIsBelowThreshold(subswarm);
    }

    private boolean diversityIsBelowThreshold(ParticleSubSwarmOptimization subswarm) {
        double meanDistanceFromGBestPos = subswarm.getEuclideanDiversity();
        return meanDistanceFromGBestPos < this.getEpsilon();
    }

    public void setEpsilon(double epsilon) {
        this.epsilon = epsilon;
    }

    public double getEpsilon() {
        return this.epsilon;
    }

    public String epsilonTipText() {
        return "threshold for the diversity of the subswarm that confines the absorption of main swarm particles";
    }
}

