/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.nichepso.absorption;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.nichepso.absorption.InterfaceAbsorptionStrategy;
import eva2.optimization.strategies.ParticleSubSwarmOptimization;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="Strategy to absorb main swarm particles into a subswarm")
public class StandardAbsorptionStrategy
implements InterfaceAbsorptionStrategy,
Serializable {
    @Override
    public Object clone() {
        return new StandardAbsorptionStrategy();
    }

    @Override
    public boolean shouldAbsorbParticleIntoSubswarm(AbstractEAIndividual indy, ParticleSubSwarmOptimization subswarm, ParticleSubSwarmOptimization mainswarm) {
        if (!subswarm.isActive()) {
            return false;
        }
        return this.particleLiesInSubswarmRadius(indy, subswarm);
    }

    private boolean particleLiesInSubswarmRadius(AbstractEAIndividual indy, ParticleSubSwarmOptimization subswarm) {
        double R = subswarm.getBoundSwarmRadius();
        AbstractEAIndividual gbest = subswarm.getGBestIndividual();
        double dist = subswarm.distance(indy, gbest);
        return dist <= R;
    }

    @Override
    public void absorbParticle(AbstractEAIndividual indy, ParticleSubSwarmOptimization subswarm, ParticleSubSwarmOptimization mainswarm) {
        if (!subswarm.isActive()) {
            System.out.println("absorbParticle: trying to absorb a particle into an inactive sub-swarm.");
            return;
        }
        subswarm.add(indy);
        subswarm.populationSizeHasChanged();
        mainswarm.removeSubIndividual(indy);
        mainswarm.populationSizeHasChanged();
    }
}

