/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.nichepso.deactivation;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.nichepso.deactivation.InterfaceDeactivationStrategy;
import eva2.optimization.population.Population;
import eva2.optimization.strategies.ParticleSubSwarmOptimization;
import eva2.tools.EVAERROR;
import eva2.util.annotation.Description;
import java.io.Serializable;
import java.util.List;
import java.util.Vector;

@Description(value="Strategy to deactivate subswarms")
public class ImprovementDeactivationStrategy
implements InterfaceDeactivationStrategy,
Serializable {
    private double epsilon = 1.0E-4;
    private int haltingWindow = 15;

    public ImprovementDeactivationStrategy() {
    }

    public ImprovementDeactivationStrategy(double thresh, int hwLen) {
        this.epsilon = thresh;
        this.haltingWindow = hwLen;
    }

    public ImprovementDeactivationStrategy(ImprovementDeactivationStrategy other) {
        this.epsilon = other.epsilon;
        this.haltingWindow = other.haltingWindow;
    }

    public ImprovementDeactivationStrategy(double eps) {
        this.epsilon = eps;
    }

    @Override
    public Object clone() {
        return new ImprovementDeactivationStrategy(this);
    }

    public boolean isConverged(Population pop) {
        Vector bests = (Vector)pop.getEAIndividual(0).getData("FitnessArchiveKey");
        if (bests.size() < this.haltingWindow) {
            return false;
        }
        List lst = bests.subList(bests.size() - this.haltingWindow, bests.size());
        bests = new Vector(this.haltingWindow);
        bests.addAll(lst);
        for (int i = 1; i < pop.size(); ++i) {
            for (int k = 0; k < this.haltingWindow; ++k) {
                Vector fitArch = (Vector)pop.getEAIndividual(i).getData("FitnessArchiveKey");
                int archIndex = fitArch.size() - this.haltingWindow + k;
                if (archIndex < 0 || !((Double)fitArch.get(archIndex) < (Double)bests.get(k))) continue;
                bests.set(k, fitArch.get(archIndex));
            }
        }
        Double historicHWAgo = (Double)bests.get(0);
        boolean res = true;
        for (int i = 1; i < this.haltingWindow; ++i) {
            boolean improvementHappened;
            Double historicIter = (Double)bests.get(i);
            boolean bl = improvementHappened = historicIter < historicHWAgo;
            if (!improvementHappened) continue;
            res = false;
            break;
        }
        return res;
    }

    @Override
    public boolean shouldDeactivateSubswarm(ParticleSubSwarmOptimization subswarm) {
        if (!subswarm.isActive()) {
            return false;
        }
        if (subswarm.getFitnessArchiveSize() < this.haltingWindow) {
            EVAERROR.errorMsgOnce("Warning: halting window length " + this.haltingWindow + " too long for sub swarm template, which stores only " + subswarm.getFitnessArchiveSize() + " fitness values!");
        }
        return this.isConverged(subswarm.getPopulation());
    }

    @Override
    public int[] deactivateSubswarm(ParticleSubSwarmOptimization subswarm, ParticleSubSwarmOptimization mainswarm) {
        if (!subswarm.isActive()) {
            System.out.println("deactivateSubSwarm: try to deactivate inactive subswarm");
            return null;
        }
        Population pop = subswarm.getPopulation();
        int[] particleIndices = new int[pop.size()];
        for (int i = 0; i < pop.size(); ++i) {
            AbstractEAIndividual indy = pop.getEAIndividual(i);
            particleIndices[i] = indy.getIndividualIndex();
        }
        subswarm.SetActive(false);
        return particleIndices;
    }

    public void setEpsilon(double epsilon) {
        this.epsilon = epsilon;
    }

    public double getEpsilon() {
        return this.epsilon;
    }

    public String epsilonTipText() {
        return "If the fitness improves by less than this threshold within the halting window, convergence is assumed.";
    }

    public int getHaltingWindowLen() {
        return this.haltingWindow;
    }

    public void setHaltingWindowLen(int hwLen) {
        this.haltingWindow = hwLen;
    }

    public String haltingWindowLenTipText() {
        return "The number of generations to be tested for improvement";
    }
}

