/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.nichepso.deactivation;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.nichepso.deactivation.InterfaceDeactivationStrategy;
import eva2.optimization.population.Population;
import eva2.optimization.strategies.ParticleSubSwarmOptimization;
import eva2.tools.EVAERROR;
import eva2.util.annotation.Description;
import java.io.Serializable;
import java.util.Vector;

@Description(value="Strategy to deactivate subswarms")
public class StandardDeactivationStrategy
implements InterfaceDeactivationStrategy,
Serializable {
    private double epsilon = 1.0E-4;
    private int stdDevHorizon = 3;

    public StandardDeactivationStrategy() {
    }

    public StandardDeactivationStrategy(StandardDeactivationStrategy other) {
        this.epsilon = other.epsilon;
        this.stdDevHorizon = other.stdDevHorizon;
    }

    public StandardDeactivationStrategy(double eps, int horizon) {
        this.epsilon = eps;
        this.stdDevHorizon = horizon;
    }

    public StandardDeactivationStrategy(double eps) {
        this.epsilon = eps;
    }

    @Override
    public Object clone() {
        return new StandardDeactivationStrategy(this);
    }

    public boolean areAllConverged(Population pop) {
        for (int i = 0; i < pop.size(); ++i) {
            double value;
            AbstractEAIndividual currentindy = pop.getEAIndividual(i);
            if (this.stdDevHorizon == 3) {
                value = (Double)currentindy.getData("StdDevKey");
            } else {
                Vector fitArch = (Vector)currentindy.getData("FitnessArchiveKey");
                value = ParticleSubSwarmOptimization.stdDev(fitArch, this.stdDevHorizon);
            }
            if (!(value > this.getEpsilon())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean shouldDeactivateSubswarm(ParticleSubSwarmOptimization subswarm) {
        if (!subswarm.isActive()) {
            return false;
        }
        if (subswarm.getFitnessArchiveSize() < this.stdDevHorizon) {
            EVAERROR.errorMsgOnce("Warning: halting window length " + this.stdDevHorizon + " too long for sub swarm template, which stores only " + subswarm.getFitnessArchiveSize() + " fitness values!");
        }
        return this.areAllConverged(subswarm.getPopulation());
    }

    @Override
    public int[] deactivateSubswarm(ParticleSubSwarmOptimization subswarm, ParticleSubSwarmOptimization mainswarm) {
        if (!subswarm.isActive()) {
            System.out.println("deactivateSubSwarm: try to deactivate inactive subswarm");
            return null;
        }
        Population pop = subswarm.getPopulation();
        int[] particleIndices = new int[pop.size()];
        for (int i = 0; i < pop.size(); ++i) {
            AbstractEAIndividual indy = pop.getEAIndividual(i);
            particleIndices[i] = indy.getIndividualIndex();
        }
        subswarm.SetActive(false);
        return particleIndices;
    }

    public void setEpsilon(double epsilon) {
        this.epsilon = epsilon;
    }

    public double getEpsilon() {
        return this.epsilon;
    }

    public String epsilonTipText() {
        return "threshold used to identify converged particles";
    }

    public int getStdDevHorizon() {
        return this.stdDevHorizon;
    }

    public void setStdDevHorizon(int stdDevHorizon) {
        this.stdDevHorizon = stdDevHorizon;
    }

    public String stdDevHorizonTipText() {
        return "The number of past fitness values to use for deactivation indication, note theres a maximum defined by the NichePSO fitness archiving.";
    }
}

