/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.nichepso.merging;

import eva2.optimization.operator.nichepso.merging.StandardMergingStrategy;
import eva2.optimization.strategies.ParticleSubSwarmOptimization;
import eva2.util.annotation.Description;
import java.util.Vector;

@Description(value="Strategy to merge subswarms")
public class ScatterMergingStrategy
extends StandardMergingStrategy {
    public ScatterMergingStrategy() {
    }

    public ScatterMergingStrategy(double theMu) {
        super(theMu);
    }

    @Override
    public void mergeSubswarms(int i, int j, Vector<ParticleSubSwarmOptimization> subSwarms, ParticleSubSwarmOptimization mainSwarm) {
        ParticleSubSwarmOptimization borg = subSwarms.get(i);
        ParticleSubSwarmOptimization others = subSwarms.get(j);
        if (borg.isActive() && others.isActive()) {
            this.mergeActiveSubswarms(i, j, subSwarms, mainSwarm);
            return;
        }
        if (!borg.isActive() && !others.isActive()) {
            this.mergeInactiveSubswarms(i, j, subSwarms, mainSwarm);
            return;
        }
        System.out.print("ScatterMergingStrategy.mergeSubswarms problem: subswarms not of equal state.");
    }

    private void mergeInactiveSubswarms(int i, int j, Vector<ParticleSubSwarmOptimization> subSwarms, ParticleSubSwarmOptimization mainSwarm) {
        ParticleSubSwarmOptimization borg = subSwarms.get(i);
        ParticleSubSwarmOptimization others = subSwarms.get(j);
        borg.addPopulation(others);
        borg.populationSizeHasChanged();
        subSwarms.remove(j);
    }

    private void mergeActiveSubswarms(int i, int j, Vector<ParticleSubSwarmOptimization> subSwarms, ParticleSubSwarmOptimization mainSwarm) {
        mainSwarm.reinitIndividuals(subSwarms.get(j).getPopulation().size());
        int calls = subSwarms.get(j).getPopulation().getFunctionCalls();
        mainSwarm.getPopulation().incrFunctionCallsBy(calls);
        subSwarms.remove(j);
    }
}

