/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.nichepso.merging;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceESIndividual;
import eva2.optimization.operator.distancemetric.EuclideanMetric;
import eva2.optimization.operator.distancemetric.PhenotypeMetric;
import eva2.optimization.operator.nichepso.merging.InterfaceMergingStrategy;
import eva2.optimization.strategies.ParticleSubSwarmOptimization;
import eva2.util.annotation.Description;
import java.io.Serializable;
import java.util.Vector;

@Description(value="Strategy to merge subswarms")
public class StandardMergingStrategy
implements InterfaceMergingStrategy,
Serializable {
    private double mu = 0.001;

    public StandardMergingStrategy() {
    }

    public StandardMergingStrategy(double theMu) {
        this.mu = theMu;
    }

    public StandardMergingStrategy(StandardMergingStrategy other) {
        this.mu = other.mu;
    }

    @Override
    public Object clone() {
        return new StandardMergingStrategy(this);
    }

    @Override
    public boolean shouldMergeSubswarms(ParticleSubSwarmOptimization subswarm1, ParticleSubSwarmOptimization subswarm2) {
        if (subswarm1.isActive() && !subswarm2.isActive()) {
            return false;
        }
        if (!subswarm1.isActive() && subswarm2.isActive()) {
            return false;
        }
        return this.subswarmsOverlapOrAreVeryClose(subswarm1, subswarm2);
    }

    private boolean subswarmsOverlapOrAreVeryClose(ParticleSubSwarmOptimization subswarm1, ParticleSubSwarmOptimization subswarm2) {
        double Rj;
        double Ri;
        double dist;
        AbstractEAIndividual gbesti = subswarm1.getGBestIndividual();
        AbstractEAIndividual gbestj = subswarm2.getGBestIndividual();
        InterfaceESIndividual i1 = null;
        InterfaceESIndividual i2 = null;
        if (gbesti instanceof InterfaceESIndividual) {
            i1 = (InterfaceESIndividual)((Object)gbesti);
            i2 = (InterfaceESIndividual)((Object)gbestj);
        }
        if ((dist = i1 != null ? EuclideanMetric.euclideanDistance(i1.getDGenotype(), i2.getDGenotype()) : subswarm1.distance(gbesti, gbestj)) < subswarm1.getMaxAllowedSwarmRadiusAbs() + subswarm2.getMaxAllowedSwarmRadiusAbs() && dist < (Ri = subswarm1.getBoundSwarmRadius()) + (Rj = subswarm2.getBoundSwarmRadius())) {
            return true;
        }
        double dist_norm = i1 != null ? EuclideanMetric.normedEuclideanDistance(i1.getDGenotype(), i1.getDoubleRange(), i2.getDGenotype(), i2.getDoubleRange()) : PhenotypeMetric.dist(gbesti, gbestj);
        return dist_norm < this.getMu();
    }

    @Override
    public void mergeSubswarms(int i, int j, Vector<ParticleSubSwarmOptimization> subSwarms, ParticleSubSwarmOptimization mainSwarm) {
        ParticleSubSwarmOptimization borg = subSwarms.get(i);
        ParticleSubSwarmOptimization others = subSwarms.get(j);
        borg.addPopulation(others);
        borg.populationSizeHasChanged();
        subSwarms.remove(j);
    }

    public void setMu(double mu) {
        this.mu = mu;
    }

    public double getMu() {
        return this.mu;
    }

    public String muTipText() {
        return "threshold used to merge subswarms that lie very close but have no spatial extent";
    }
}

