/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.nichepso.subswarmcreation;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.ESIndividualDoubleData;
import eva2.optimization.operator.mutation.MutateESFixedStepSize;
import eva2.optimization.operator.nichepso.subswarmcreation.StandardSubswarmCreationStrategy;
import eva2.optimization.population.Population;
import eva2.optimization.strategies.ParticleSubSwarmOptimization;

public class GenerateNeighborSubswarmCreationStrategy
extends StandardSubswarmCreationStrategy {
    private double mu = 0.1;

    @Override
    public void createSubswarm(ParticleSubSwarmOptimization preparedSubswarm, AbstractEAIndividual indy, ParticleSubSwarmOptimization mainSwarm) {
        AbstractEAIndividual neighbor = mainSwarm.getMemberNeighbor(indy);
        AbstractEAIndividual indypbest = (AbstractEAIndividual)indy.getData("PersonalBestKey");
        AbstractEAIndividual neighpbest = (AbstractEAIndividual)neighbor.getData("PersonalBestKey");
        neighbor = this.generateNeighborFrom(indy, mainSwarm);
        AbstractEAIndividual worst = mainSwarm.getParticleWithWorstPBestButNot(indy);
        Population pop = new Population(2);
        pop.add(indy);
        pop.add(neighbor);
        preparedSubswarm.setPopulation(pop);
        preparedSubswarm.populationSizeHasChanged();
        mainSwarm.removeSubIndividual(indy);
        mainSwarm.removeSubIndividual(worst);
        mainSwarm.populationSizeHasChanged();
    }

    private AbstractEAIndividual generateNeighborFrom(AbstractEAIndividual indy, ParticleSubSwarmOptimization mainswarm) {
        ESIndividualDoubleData neighbor = (ESIndividualDoubleData)indy.clone();
        MutateESFixedStepSize mutator = new MutateESFixedStepSize();
        mutator.setSigma(this.getMu());
        neighbor.setMutationOperator(mutator);
        neighbor.setMutationProbability(1.0);
        neighbor.mutate();
        neighbor.putData("BestFitness", neighbor.getFitness());
        neighbor.putData("BestPosition", neighbor.getDGenotype());
        return neighbor;
    }

    public void setMu(double generateNeighborWithMutationStep) {
        this.mu = generateNeighborWithMutationStep;
    }

    public double getMu() {
        return this.mu;
    }

    public String muTipText() {
        return "mutation step size used to generate a neighbor";
    }
}

