/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.nichepso.subswarmcreation;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.nichepso.subswarmcreation.InterfaceSubswarmCreationStrategy;
import eva2.optimization.population.Population;
import eva2.optimization.strategies.ParticleSubSwarmOptimization;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="Strategy to create subswarms from the main swarm")
public class StandardSubswarmCreationStrategy
implements InterfaceSubswarmCreationStrategy,
Serializable {
    protected double delta = 1.0E-4;

    public StandardSubswarmCreationStrategy(double theDelta) {
        this.delta = theDelta;
    }

    public StandardSubswarmCreationStrategy() {
        this.delta = 1.0E-4;
    }

    @Override
    public Object clone() {
        return new StandardSubswarmCreationStrategy(this.delta);
    }

    @Override
    public boolean shouldCreateSubswarm(AbstractEAIndividual indy, ParticleSubSwarmOptimization mainswarm) {
        if (this.createSubswarmConstraintViolation(indy, mainswarm)) {
            return false;
        }
        double stddev = (Double)indy.getData("StdDevKey");
        return stddev < this.getDelta();
    }

    public boolean createSubswarmConstraintViolation(AbstractEAIndividual indy, ParticleSubSwarmOptimization mainswarm) {
        boolean result = false;
        if (mainswarm.getPopulation().size() < 2) {
            result = true;
        }
        return result;
    }

    @Override
    public void createSubswarm(ParticleSubSwarmOptimization preparedSubswarm, AbstractEAIndividual indy, ParticleSubSwarmOptimization mainSwarm) {
        AbstractEAIndividual neighbor = mainSwarm.getMemberNeighbor(indy);
        Population pop = new Population(2);
        pop.add(indy);
        pop.add(neighbor);
        preparedSubswarm.setPopulation(pop);
        preparedSubswarm.populationSizeHasChanged();
        mainSwarm.removeSubIndividual(indy);
        mainSwarm.removeSubIndividual(neighbor);
        mainSwarm.populationSizeHasChanged();
    }

    public double getDelta() {
        return this.delta;
    }

    public void setDelta(double delta) {
        this.delta = delta;
    }

    public String deltaTipText() {
        return "threshold used to identify converging particles which lead to the creation of subswarms";
    }
}

