/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.paramcontrol;

import eva2.gui.BeanInspector;
import eva2.optimization.operator.paramcontrol.ParamAdaption;
import eva2.optimization.population.Population;
import eva2.tools.math.Mathematics;
import java.io.Serializable;

public abstract class AbstractLinearParamAdaption
implements ParamAdaption,
Serializable {
    private double startV = 0.7;
    private double endV = 0.2;

    public AbstractLinearParamAdaption(AbstractLinearParamAdaption o) {
        this.startV = o.startV;
        this.endV = o.endV;
    }

    public AbstractLinearParamAdaption(double startValue, double endValue) {
        this.startV = startValue;
        this.endV = endValue;
    }

    @Override
    public abstract Object clone();

    @Override
    public Object calcValue(Object obj, Population pop, int iteration, int maxIteration) {
        return Mathematics.linearInterpolation(iteration, 0.0, maxIteration, this.startV, this.endV);
    }

    @Override
    public abstract String getControlledParam();

    public String controlledParamTipText() {
        return "The name of the parameter to be controlled by this adaption scheme.";
    }

    @Override
    public void init(Object obj, Population pop, Object[] initialValues) {
        BeanInspector.setMem(obj, this.getControlledParam(), this.startV);
    }

    @Override
    public void finish(Object obj, Population pop) {
    }

    public double getStartV() {
        return this.startV;
    }

    public void setStartV(double startV) {
        this.startV = startV;
    }

    public String startVTipText() {
        return "The initial value.";
    }

    public double getEndV() {
        return this.endV;
    }

    public void setEndV(double endV) {
        this.endV = endV;
    }

    public String endVTipText() {
        return "The final value.";
    }

    public String getName() {
        return "Lin.adpt." + this.getControlledParam() + "(" + this.startV + "-" + this.endV + ")";
    }
}

