/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.paramcontrol;

import eva2.gui.BeanInspector;
import eva2.optimization.operator.paramcontrol.InterfaceParameterControl;
import eva2.optimization.population.Population;

public abstract class AbstractParameterControl
implements InterfaceParameterControl {
    public Object[] initialValues = null;

    public AbstractParameterControl() {
    }

    public AbstractParameterControl(AbstractParameterControl o) {
        this.initialValues = (Object[])o.initialValues.clone();
    }

    @Override
    public abstract Object clone();

    @Override
    public void init(Object obj, Population initialPop) {
        String[] params = this.getControlledParameters();
        if (params != null) {
            this.initialValues = new Object[params.length];
            for (int i = 0; i < params.length; ++i) {
                this.initialValues[i] = BeanInspector.getMem(obj, params[i]);
            }
        }
    }

    @Override
    public void finish(Object obj, Population finalPop) {
        String[] params = this.getControlledParameters();
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                BeanInspector.setMem(obj, params[i], this.initialValues[i]);
            }
        }
    }

    @Override
    public void updateParameters(Object obj, Population pop, int iteration, int maxIteration) {
        String[] params = this.getControlledParameters();
        Object[] vals = this.getValues(obj, pop, iteration, maxIteration);
        for (int i = 0; i < params.length; ++i) {
            if (BeanInspector.setMem(obj, params[i], vals[i])) continue;
            System.err.println("Error: failed to set parameter from parameter control " + this.getClass().getName());
            System.err.println("  Tried to set name/val: " + params[i] + " / " + BeanInspector.toString(vals[i]));
        }
    }

    @Override
    public void updateParameters(Object obj) {
        this.updateParameters(obj, null, -1, -1);
    }

    public abstract String[] getControlledParameters();

    public abstract Object[] getValues(Object var1, Population var2, int var3, int var4);
}

