/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.paramcontrol;

import eva2.optimization.operator.paramcontrol.GenericParamAdaption;
import eva2.optimization.operator.paramcontrol.ParamAdaption;
import eva2.optimization.population.Population;
import eva2.optimization.strategies.CBNPSO;
import java.io.Serializable;

public class CbpsoFitnessThresholdBasedAdaption
implements ParamAdaption,
GenericParamAdaption,
Serializable {
    private double initialVal = 10000.0;
    private double lowerBnd = 1000.0;
    private double upperBnd = 15000.0;
    private double currentVal = this.initialVal;
    private double incFact = 1.2;
    private double decFact = 1.0 / this.incFact;
    private int adptIntervalGenerations = 10;
    private int lastAdaption = -1;
    private String paramName = "sigmaAdaptionPeriod";
    private double minInterestingRatio = 0.5;
    private double maxInterestingRatio = 0.8;

    public CbpsoFitnessThresholdBasedAdaption() {
    }

    public CbpsoFitnessThresholdBasedAdaption(int initialV, int minV, int maxV, double incFact, int generationInterval, double minIntRatio, double maxIntRatio) {
        this.initialVal = initialV;
        this.lowerBnd = minV;
        this.upperBnd = maxV;
        this.currentVal = this.initialVal;
        this.incFact = incFact;
        this.decFact = 1.0 / incFact;
        this.adptIntervalGenerations = generationInterval;
        this.lastAdaption = -1;
        this.minInterestingRatio = minIntRatio;
        this.maxInterestingRatio = maxIntRatio;
    }

    public CbpsoFitnessThresholdBasedAdaption(CbpsoFitnessThresholdBasedAdaption o) {
        this.initialVal = o.initialVal;
        this.lowerBnd = o.lowerBnd;
        this.upperBnd = o.upperBnd;
        this.currentVal = o.currentVal;
        this.incFact = o.incFact;
        this.decFact = o.decFact;
        this.paramName = o.paramName;
        this.adptIntervalGenerations = o.adptIntervalGenerations;
        this.lastAdaption = o.lastAdaption;
        this.minInterestingRatio = o.minInterestingRatio;
        this.maxInterestingRatio = o.maxInterestingRatio;
    }

    @Override
    public Object clone() {
        return new CbpsoFitnessThresholdBasedAdaption(this);
    }

    @Override
    public Object calcValue(Object obj, Population pop, int iteration, int maxIteration) {
        if (obj instanceof CBNPSO) {
            CBNPSO cbpso = (CBNPSO)obj;
            this.checkForAdaption(cbpso, pop, iteration, maxIteration);
        } else {
            System.err.println("Invalid object!");
        }
        return this.currentVal;
    }

    private void checkForAdaption(CBNPSO cbpso, Population pop, int iteration, int maxIteration) {
        double oldVal = this.currentVal;
        if (this.isPossibleAdaptionTime(pop)) {
            double interestingRatio = cbpso.getInterestingSolutionRatio();
            if (interestingRatio >= 0.0 && interestingRatio < this.minInterestingRatio) {
                this.adaptValue(this.decFact, pop);
            } else if (interestingRatio > this.maxInterestingRatio) {
                this.adaptValue(this.incFact, pop);
            }
            if (oldVal != this.currentVal) {
                this.setShift(cbpso, pop, oldVal, this.currentVal);
            }
        }
    }

    private void setShift(CBNPSO cbpso, Population pop, double oldVal, double currentVal2) {
        double k = (double)pop.getFunctionCalls() / this.currentVal;
        int diff = (int)((double)pop.getFunctionCalls() - (double)((int)k) * this.currentVal);
        cbpso.setSigmaAdaptionShift(diff);
    }

    private void adaptValue(double fact, Population pop) {
        this.currentVal *= fact;
        this.currentVal = Math.max(this.lowerBnd, Math.min(this.upperBnd, this.currentVal));
        this.lastAdaption = pop.getGeneration();
        this.adptIntervalGenerations = (int)(this.currentVal / (double)pop.getTargetSize());
    }

    private boolean isPossibleAdaptionTime(Population pop) {
        return this.lastAdaption + this.adptIntervalGenerations <= pop.getGeneration();
    }

    @Override
    public void finish(Object obj, Population pop) {
    }

    @Override
    public String getControlledParam() {
        return this.paramName;
    }

    @Override
    public void init(Object obj, Population pop, Object[] initialValues) {
        this.currentVal = this.initialVal;
        this.lastAdaption = 0;
        this.adptIntervalGenerations = (int)(this.currentVal / (double)pop.getTargetSize());
    }

    @Override
    public void setControlledParam(String prm) {
        this.paramName = prm;
    }

    public void setInitialVal(double initialVal) {
        this.initialVal = initialVal;
    }

    public double getInitialVal() {
        return this.initialVal;
    }
}

