/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.paramcontrol;

import eva2.optimization.individuals.InterfaceDataTypeDouble;
import eva2.optimization.operator.constraint.AbstractConstraint;
import eva2.optimization.operator.paramcontrol.ParamAdaption;
import eva2.optimization.population.Population;
import eva2.tools.math.Mathematics;
import eva2.util.annotation.Description;
import java.io.Serializable;
import java.util.LinkedList;

@Description(value="Adapt a constraint's penalty factor (esp. fitness based) if the population contained only valid or only invalid individuals for some generations.")
public class ConstraintBasedAdaption
implements ParamAdaption,
Serializable {
    private double betaInc = 1.5;
    private double betaDec = 0.7;
    private double initialPenalty = 1.0;
    private double minPenalty = 0.01;
    private double maxPenalty = 100.0;
    private double currentFactor = 1.0;
    private int genGap = 5;
    LinkedList<Boolean> lastBestSatisfactionState = new LinkedList();
    private static String target = "penaltyFactor";

    public ConstraintBasedAdaption() {
    }

    public ConstraintBasedAdaption(ConstraintBasedAdaption o) {
        this.betaInc = o.betaInc;
        this.betaDec = o.betaDec;
        this.genGap = o.genGap;
    }

    @Override
    public Object clone() {
        return new ConstraintBasedAdaption(this);
    }

    @Override
    public Object calcValue(Object obj, Population pop, int iteration, int maxIteration) {
        boolean changed = false;
        if (!(obj instanceof AbstractConstraint)) {
            System.err.println(this.getClass().getSimpleName() + " cant control " + obj.getClass().getSimpleName() + " ! ");
        } else {
            boolean bestIsFeasible;
            if (this.lastBestSatisfactionState.size() == this.genGap) {
                this.lastBestSatisfactionState.poll();
            }
            if (!this.lastBestSatisfactionState.offer(bestIsFeasible = ((AbstractConstraint)obj).isSatisfied(((InterfaceDataTypeDouble)((Object)pop.getBestEAIndividual())).getDoubleDataWithoutUpdate()))) {
                System.err.println("Error, could not push best indy state!");
            }
            changed = this.maybeAdaptFactor((AbstractConstraint)obj);
        }
        double curPen = this.initialPenalty * this.currentFactor;
        if (curPen < this.minPenalty) {
            this.currentFactor = this.minPenalty / this.initialPenalty;
            curPen = this.minPenalty;
        } else if (curPen > this.maxPenalty) {
            this.currentFactor = this.maxPenalty / this.initialPenalty;
            curPen = this.maxPenalty;
        }
        return curPen;
    }

    private boolean maybeAdaptFactor(AbstractConstraint constr) {
        boolean changed = false;
        if (this.lastBestSatisfactionState.size() >= this.genGap) {
            boolean allValid = true;
            boolean allInvalid = true;
            for (Boolean isFeasible : this.lastBestSatisfactionState) {
                if (isFeasible.booleanValue()) {
                    allInvalid = false;
                    continue;
                }
                allValid = false;
            }
            if (allValid) {
                this.currentFactor *= this.betaDec;
                changed = true;
            } else if (allInvalid) {
                changed = true;
                this.currentFactor *= this.betaInc;
            }
        }
        return changed;
    }

    @Override
    public String getControlledParam() {
        return target;
    }

    public double getBetaInc() {
        return this.betaInc;
    }

    public void setBetaInc(double d) {
        this.betaInc = d;
    }

    public String betaIncTipText() {
        return "The increase factor for the penalty.";
    }

    public double getBetaDec() {
        return this.betaDec;
    }

    public void setBetaDec(double d) {
        this.betaDec = d;
    }

    public String betaDecTipText() {
        return "The decrease factor for the penalty.";
    }

    public int getGenGap() {
        return this.genGap;
    }

    public void setGenGap(int v) {
        this.genGap = v;
    }

    public String genGapTipText() {
        return "The number of generations regarded.";
    }

    @Override
    public void finish(Object obj, Population pop) {
        this.lastBestSatisfactionState.clear();
        ((AbstractConstraint)obj).setPenaltyFactor(this.initialPenalty);
    }

    @Override
    public void init(Object obj, Population pop, Object[] initialValues) {
        this.initialPenalty = ((AbstractConstraint)obj).getPenaltyFactor();
        if (this.minPenalty > this.maxPenalty) {
            System.err.println("Error in " + this.getClass().getSimpleName() + ", inconsistent penalty factor restrictions!");
        }
        this.initialPenalty = Mathematics.projectValue(this.initialPenalty, this.minPenalty, this.maxPenalty);
        this.lastBestSatisfactionState.clear();
        this.currentFactor = 1.0;
    }

    public double getMinPenalty() {
        return this.minPenalty;
    }

    public void setMinPenalty(double minPenalty) {
        this.minPenalty = minPenalty;
    }

    public String minPenaltyTipText() {
        return "The minimum penalty factor.";
    }

    public double getMaxPenalty() {
        return this.maxPenalty;
    }

    public void setMaxPenalty(double maxPenalty) {
        this.maxPenalty = maxPenalty;
    }

    public String maxPenaltyTipText() {
        return "The maximum penalty factor.";
    }

    public String getName() {
        return "Adaptive penalty factor";
    }
}

