/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.paramcontrol;

import eva2.optimization.operator.paramcontrol.AbstractLinearParamAdaption;
import eva2.optimization.operator.paramcontrol.GenericParamAdaption;
import eva2.optimization.operator.paramcontrol.InterfaceHasUpperDoubleBound;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="Simple linear parameter adaption.")
public class LinearParamAdaption
extends AbstractLinearParamAdaption
implements InterfaceHasUpperDoubleBound,
GenericParamAdaption,
Serializable {
    String target = "undefinedParameter";

    public LinearParamAdaption() {
        super(0.7, 0.2);
        this.target = "undefinedParameter";
    }

    public LinearParamAdaption(LinearParamAdaption o) {
        super(o);
        this.target = o.target;
    }

    public LinearParamAdaption(String target, double startValue, double endValue) {
        super(startValue, endValue);
        this.target = target;
    }

    @Override
    public Object clone() {
        return new LinearParamAdaption(this);
    }

    @Override
    public String getControlledParam() {
        return this.target;
    }

    @Override
    public void setControlledParam(String target) {
        this.target = target;
    }

    public String[] customPropertyOrder() {
        return new String[]{"startV", "endV"};
    }

    @Override
    public double getUpperBnd() {
        return Math.max(this.getEndV(), this.getStartV());
    }

    @Override
    public void SetUpperBnd(double u) {
        if (this.getEndV() == this.getStartV()) {
            this.setEndV(u);
            this.setStartV(u);
        } else if (this.getEndV() > this.getStartV()) {
            if (u < this.getStartV()) {
                System.err.println("Warning, changing direction of linear adaption!");
            }
            this.setEndV(u);
        } else {
            if (u < this.getEndV()) {
                System.err.println("Warning, changing direction of linear adaption!");
            }
            this.setStartV(u);
        }
    }
}

