/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.paramcontrol;

import eva2.optimization.operator.paramcontrol.ParamAdaption;
import eva2.optimization.population.Population;
import eva2.optimization.strategies.ParticleSwarmOptimization;
import eva2.tools.math.Mathematics;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="Controls the inertness factor based on the average velocity.")
public class PSOActivityFeedbackControl
implements ParamAdaption,
Serializable {
    private double minInert = 0.5;
    private double maxInert = 1.0;
    private double startAct = 0.17;
    private double endAct = 0.01;
    private double deltaInertness = 0.1;
    private boolean exponentialSchedule = true;
    private static String target = "inertnessOrChi";

    public PSOActivityFeedbackControl() {
    }

    public PSOActivityFeedbackControl(PSOActivityFeedbackControl o) {
        this.minInert = o.minInert;
        this.maxInert = o.maxInert;
        this.startAct = o.startAct;
        this.endAct = o.endAct;
        this.deltaInertness = o.deltaInertness;
    }

    @Override
    public Object clone() {
        return new PSOActivityFeedbackControl(this);
    }

    @Override
    public Object calcValue(Object obj, Population pop, int iteration, int maxIteration) {
        if (obj instanceof ParticleSwarmOptimization) {
            ParticleSwarmOptimization pso = (ParticleSwarmOptimization)obj;
            double currentAct = this.calculateActivity(pso);
            double currentInertness = pso.getInertnessOrChi();
            Double val = this.calcNewInertness(currentInertness, currentAct, this.desiredActivity(iteration, maxIteration));
            return val;
        }
        System.err.println("Cant control this object type!!");
        return null;
    }

    @Override
    public String getControlledParam() {
        return target;
    }

    private double calcNewInertness(double currentInertness, double currentAct, double desiredActivity) {
        if (currentAct < desiredActivity) {
            return Math.min(this.maxInert, currentInertness + this.deltaInertness);
        }
        if (currentAct > desiredActivity) {
            return Math.max(this.minInert, currentInertness - this.deltaInertness);
        }
        return currentInertness;
    }

    private double desiredActivity(int iteration, int maxIteration) {
        if (this.exponentialSchedule) {
            return this.startAct * Math.pow(this.endAct / this.startAct, (double)iteration / (double)maxIteration);
        }
        return Mathematics.linearInterpolation(iteration, 0.0, maxIteration, this.startAct, this.endAct);
    }

    private double calculateActivity(ParticleSwarmOptimization pso) {
        return pso.getPopulationAvgNormedVelocity(pso.getPopulation());
    }

    public double getMinInertness() {
        return this.minInert;
    }

    public void setMinInertness(double minInert) {
        this.minInert = minInert;
    }

    public String minInertnessTipText() {
        return "The minimum inertness value to be used.";
    }

    public double getMaxInertness() {
        return this.maxInert;
    }

    public void setMaxInertness(double maxInert) {
        this.maxInert = maxInert;
    }

    public String maxInertnessTipText() {
        return "The maximum inertness value to be used.";
    }

    public double getInitActivity() {
        return this.startAct;
    }

    public void setInitActivity(double startAct) {
        this.startAct = startAct;
    }

    public String initActivityTipText() {
        return "The initial target activity (relative to the range).";
    }

    public double getFinalActivity() {
        return this.endAct;
    }

    public void setFinalActivity(double endAct) {
        this.endAct = endAct;
        if (endAct == 0.0 && this.isExponentialSchedule()) {
            System.err.println("Warning: zero final activity will not work with exponential schedule, set it to small epsilon!");
        }
    }

    public String finalActivityTipText() {
        return "The final target activity (relative to the range), should be close to zero.";
    }

    public double getDeltaInertness() {
        return this.deltaInertness;
    }

    public void setDeltaInertness(double deltaInertness) {
        this.deltaInertness = deltaInertness;
    }

    public String deltaInertnessTipText() {
        return "The additive change of the inertness in each adaption step.";
    }

    @Override
    public void finish(Object obj, Population pop) {
    }

    @Override
    public void init(Object obj, Population pop, Object[] initialValues) {
    }

    public boolean isExponentialSchedule() {
        return this.exponentialSchedule;
    }

    public void setExponentialSchedule(boolean exponentialSchedule) {
        this.exponentialSchedule = exponentialSchedule;
        if (this.getFinalActivity() == 0.0) {
            System.err.println("Warning: zero final activity will not work with exponential schedule, set it to small epsilon!");
        }
    }

    public String exponentialScheduleTipText() {
        return "Use linear or exponential activity decrease schedule.";
    }
}

