/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.paramcontrol;

import eva2.gui.BeanInspector;
import eva2.optimization.operator.paramcontrol.InterfaceParameterControl;
import eva2.optimization.operator.paramcontrol.ParamAdaption;
import eva2.optimization.population.Population;
import eva2.tools.Pair;
import eva2.util.annotation.Description;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

@Description(value="Define a list of dynamically adapted parameters.")
public class ParameterControlManager
implements InterfaceParameterControl,
Serializable {
    public Object[] initialValues = null;
    private ParamAdaption[] singleAdapters = new ParamAdaption[0];

    public ParameterControlManager() {
    }

    public ParameterControlManager(ParamAdaption adaptor) {
        this.singleAdapters = new ParamAdaption[]{adaptor};
    }

    public ParameterControlManager(ParamAdaption[] adaptors) {
        this.singleAdapters = adaptors;
    }

    public ParameterControlManager(ParameterControlManager o) {
        this.initialValues = o.initialValues != null ? (Object[])o.initialValues.clone() : null;
        if (o.singleAdapters != null) {
            this.singleAdapters = new ParamAdaption[o.singleAdapters.length];
            for (int i = 0; i < this.singleAdapters.length; ++i) {
                this.singleAdapters[i] = (ParamAdaption)o.singleAdapters[i].clone();
            }
        }
    }

    @Override
    public Object clone() {
        return new ParameterControlManager(this);
    }

    @Override
    public void init(Object obj, Population initialPop) {
        String[] params = this.getControlledParameters();
        if (params != null) {
            this.initialValues = new Object[params.length];
            for (int i = 0; i < params.length; ++i) {
                this.initialValues[i] = BeanInspector.getMem(obj, params[i]);
            }
        }
        for (ParamAdaption prm : this.singleAdapters) {
            prm.init(obj, initialPop, this.initialValues);
            this.tryRecursive(prm, "initialize", new Object[]{initialPop});
        }
    }

    protected void tryRecursive(ParamAdaption prm, String method, Object[] args) {
        Object subManager = null;
        subManager = BeanInspector.callIfAvailable(prm, "getParamControl", null);
        if (subManager != null && subManager instanceof ParameterControlManager) {
            BeanInspector.callIfAvailable(subManager, method, args);
        }
    }

    @Override
    public void finish(Object obj, Population finalPop) {
        String[] params = this.getControlledParameters();
        for (ParamAdaption prm : this.singleAdapters) {
            prm.finish(obj, finalPop);
            this.tryRecursive(prm, "finish", new Object[]{finalPop});
        }
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                BeanInspector.setMem(obj, params[i], this.initialValues[i]);
            }
        }
    }

    @Override
    public void updateParameters(Object obj, Population pop, int iteration, int maxIteration) {
        String[] params = this.getControlledParameters();
        Object[] vals = this.getValues(obj, pop, iteration, maxIteration);
        for (int i = 0; i < params.length; ++i) {
            Object oldVal = BeanInspector.getMem(obj, params[i]);
            if (oldVal == null) {
                System.err.println("Error, unable to compare old and new value (ParameterControlManager");
            }
            if (BeanInspector.setMem(obj, params[i], vals[i])) continue;
            System.err.println("Error: failed to set parameter from parameter control " + this.getClass().getName());
            System.err.println("  Tried to set name/val: " + params[i] + " / " + BeanInspector.toString(vals[i]));
        }
        Object[] args = new Object[]{null, pop, iteration, maxIteration};
        for (ParamAdaption prm : this.singleAdapters) {
            args[0] = prm;
            this.tryRecursive(prm, "updateParameters", args);
        }
    }

    @Override
    public void updateParameters(Object obj) {
        this.updateParameters(obj, null, -1, -1);
    }

    public String[] getControlledParameters() {
        if (this.singleAdapters != null) {
            Vector<String> names = new Vector<String>(this.singleAdapters.length);
            for (ParamAdaption singleAdapter : this.singleAdapters) {
                String prm = singleAdapter.getControlledParam();
                if (prm == null) continue;
                names.add(prm);
            }
            return names.toArray(new String[names.size()]);
        }
        return null;
    }

    public Object[] getValues(Object obj, Population pop, int iteration, int maxIteration) {
        if (this.singleAdapters != null) {
            Object[] vals = new Object[this.singleAdapters.length];
            for (int i = 0; i < vals.length; ++i) {
                vals[i] = this.singleAdapters[i].calcValue(obj, pop, iteration, maxIteration);
            }
            return vals;
        }
        return null;
    }

    public ParamAdaption[] getSingleAdapters() {
        return this.singleAdapters;
    }

    public void setSingleAdapters(ParamAdaption[] singleAdapters) {
        this.singleAdapters = singleAdapters;
    }

    public void addSingleAdapter(ParamAdaption pa) {
        if (this.singleAdapters == null) {
            this.setSingleAdapters(new ParamAdaption[]{pa});
        } else {
            ParamAdaption[] newP = new ParamAdaption[this.singleAdapters.length + 1];
            System.arraycopy(this.singleAdapters, 0, newP, 0, this.singleAdapters.length);
            newP[newP.length - 1] = pa;
            this.setSingleAdapters(newP);
        }
    }

    public String getName() {
        return "ParameterControlManager";
    }

    public static List<Object> listOfControllables(Object target) {
        Pair<String[], Object[]> propsNamesVals = BeanInspector.getPublicPropertiesOf(target, true, true);
        ArrayList<Object> controllables = new ArrayList<Object>();
        Object[] objs = (Object[])propsNamesVals.tail;
        for (int i = 0; i < objs.length; ++i) {
            if (objs[i] == null || BeanInspector.hasMethod(objs[i], "getParamControl", null) == null) continue;
            controllables.add(objs[i]);
        }
        return controllables;
    }
}

