/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.paramcontrol;

import eva2.optimization.operator.paramcontrol.GenericParamAdaption;
import eva2.optimization.operator.paramcontrol.InterfaceHasUpperDoubleBound;
import eva2.optimization.operator.paramcontrol.ParamAdaption;
import eva2.optimization.population.Population;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="Sinusoidally oscillating value, the frequency may be varyied with time. E.g. use dampening 0.9 for a slightly decreasing frequency, dampening 1.1 for a slight increase. The frequency is modified in the form sin(t) -> sin(-1+(t+1)^d)")
public class SinusoidalParamAdaption
implements InterfaceHasUpperDoubleBound,
ParamAdaption,
GenericParamAdaption,
Serializable {
    private double upperBnd = 1.0;
    private double lowerBnd = 0.0;
    private int iterationPeriod = 1000;
    private int initialShift = 0;
    private boolean beatFreq = false;
    private double medVal = 0.0;
    private String paramName = "unknownParam";
    private double dampening = 1.0;

    public SinusoidalParamAdaption() {
        this.updateMed();
    }

    public SinusoidalParamAdaption(double lower, double upper, double dampening, int period, int start, String param) {
        this.upperBnd = upper;
        this.lowerBnd = lower;
        this.iterationPeriod = period;
        this.initialShift = start;
        this.paramName = param;
        this.dampening = dampening;
        this.updateMed();
    }

    public SinusoidalParamAdaption(double lower, double upper, int period, int start, String param) {
        this(lower, upper, 1.0, period, start, param);
    }

    public SinusoidalParamAdaption(SinusoidalParamAdaption o) {
        this.upperBnd = o.upperBnd;
        this.lowerBnd = o.lowerBnd;
        this.iterationPeriod = o.iterationPeriod;
        this.initialShift = o.initialShift;
        this.medVal = o.medVal;
        this.paramName = o.paramName;
        this.dampening = o.dampening;
        this.updateMed();
    }

    @Override
    public Object calcValue(Object obj, Population pop, int iteration, int maxIteration) {
        double res = 0.0;
        double t = Math.PI * 2 / (double)this.iterationPeriod * (double)(iteration - this.initialShift);
        if (this.dampening != 1.0) {
            t = SinusoidalParamAdaption.dampen(t, this.dampening);
        }
        res = this.medVal + (this.upperBnd - this.lowerBnd) * 0.5 * Math.sin(t);
        return res;
    }

    public String getName() {
        return "SinAdapt(" + this.getControlledParam() + "_" + this.lowerBnd + "_" + this.upperBnd + "_" + this.iterationPeriod + (this.dampening != 1.0 ? "_dmp-" + this.dampening : "") + ")";
    }

    private static double dampen(double t, double dampeningExp) {
        return Math.pow(t + 1.0, dampeningExp) - 1.0;
    }

    @Override
    public Object clone() {
        return new SinusoidalParamAdaption(this);
    }

    @Override
    public void finish(Object obj, Population pop) {
    }

    @Override
    public String getControlledParam() {
        return this.paramName;
    }

    @Override
    public void init(Object obj, Population pop, Object[] initialValues) {
    }

    @Override
    public void setControlledParam(String prm) {
        this.paramName = prm;
    }

    public String controlledParamTipText() {
        return "The name of the generic parameter to be adapted.";
    }

    @Override
    public double getUpperBnd() {
        return this.upperBnd;
    }

    public void setUpperBnd(double upperBnd) {
        this.upperBnd = upperBnd;
        this.updateMed();
    }

    @Override
    public void SetUpperBnd(double u) {
        this.setUpperBnd(u);
    }

    public String upperBndTipText() {
        return "The upper deviation of the oscillation.";
    }

    public double getLowerBnd() {
        return this.lowerBnd;
    }

    public void setLowerBnd(double lowerBnd) {
        this.lowerBnd = lowerBnd;
        this.updateMed();
    }

    private void updateMed() {
        this.medVal = 0.5 * (this.upperBnd + this.lowerBnd);
    }

    public String lowerBndTipText() {
        return "The lower deviation of the oscillation.";
    }

    public int getIterationPeriod() {
        return this.iterationPeriod;
    }

    public void setIterationPeriod(int iterationPeriod) {
        this.iterationPeriod = iterationPeriod;
    }

    public String iterationPeriodTipText() {
        return "The period length of the oscillation, in iterations.";
    }

    public int getInitialShift() {
        return this.initialShift;
    }

    public void setInitialShift(int initialShift) {
        this.initialShift = initialShift;
    }

    public String initialShiftTipText() {
        return "The initial phase shift of the sinusoidal, in iterations.";
    }

    public double getDampening() {
        return this.dampening;
    }

    public void setDampening(double dampening) {
        this.dampening = dampening;
    }

    public String dampeningTipText() {
        return "Dampening exponent for frequency variation: values above 1 increase frequency with time, values below dampen it.";
    }
}

