/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.paramcontrol;

import eva2.optimization.operator.paramcontrol.GenericParamAdaption;
import eva2.optimization.operator.paramcontrol.InterfaceHasUpperDoubleBound;
import eva2.optimization.operator.paramcontrol.ParamAdaption;
import eva2.optimization.population.Population;
import eva2.optimization.population.SolutionSet;
import eva2.optimization.strategies.InterfaceOptimizer;
import java.io.Serializable;

public class SuccessBasedAdaption
implements ParamAdaption,
InterfaceHasUpperDoubleBound,
GenericParamAdaption,
Serializable {
    private double fitThreshold;
    private int fitCrit = 0;
    private double targetRate = 0.75;
    private String paramStr = "unnamedParameter";
    private double lowerBnd = 0.1;
    private double upperBnd = 2.0;
    private double curValue;
    private double incFact = 1.05;

    public SuccessBasedAdaption() {
    }

    public SuccessBasedAdaption(double thresh, int crit, double rate) {
        this.setFitThreshold(thresh);
        this.fitCrit = crit;
        this.targetRate = rate;
    }

    public SuccessBasedAdaption(SuccessBasedAdaption successBasedAdaption) {
    }

    @Override
    public Object clone() {
        return new SuccessBasedAdaption(this);
    }

    @Override
    public Object calcValue(Object obj, Population pop, int iteration, int maxIteration) {
        if (obj instanceof InterfaceOptimizer) {
            SolutionSet sols = (SolutionSet)((InterfaceOptimizer)obj).getAllSolutions();
            double curSuccRate = this.getSuccessRate(sols.getSolutions());
            if (curSuccRate < this.targetRate) {
                this.decrease();
            } else {
                this.increase();
            }
            System.out.println("Succ rate is " + curSuccRate + ", setting val " + this.curValue);
            return this.curValue;
        }
        System.err.println("Unknown object to be controlled by " + this.getClass().getName());
        return null;
    }

    private void increase() {
        this.curValue = Math.min(this.upperBnd, this.incFact * this.curValue);
    }

    private void decrease() {
        this.curValue = Math.max(this.lowerBnd, 1.0 / this.incFact * this.curValue);
    }

    private double getSuccessRate(Population solutions) {
        int numSucc = solutions.filterByFitness(this.getFitThreshold(), this.fitCrit).size();
        return (double)numSucc / (double)solutions.size();
    }

    @Override
    public void finish(Object obj, Population pop) {
    }

    @Override
    public String getControlledParam() {
        return this.paramStr;
    }

    @Override
    public void init(Object obj, Population pop, Object[] initialValues) {
        this.curValue = 0.5 * (this.upperBnd + this.lowerBnd);
    }

    @Override
    public void setControlledParam(String prm) {
        this.paramStr = prm;
    }

    @Override
    public void SetUpperBnd(double u) {
        this.upperBnd = u;
    }

    @Override
    public double getUpperBnd() {
        return this.upperBnd;
    }

    public void setFitThreshold(double fitThreshold) {
        this.fitThreshold = fitThreshold;
    }

    public double getFitThreshold() {
        return this.fitThreshold;
    }
}

