/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.paretofrontmetrics;

import eva2.gui.PropertyFilePath;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.archiving.ArchivingAllDominating;
import eva2.optimization.operator.paretofrontmetrics.InterfaceParetoFrontMetric;
import eva2.optimization.population.Population;
import eva2.optimization.tools.FileTools;
import eva2.problems.AbstractMultiObjectiveOptimizationProblem;
import eva2.util.annotation.Description;
import java.io.Serializable;
import java.util.ArrayList;

@Description(value="This method calculates the maximum distance to the reference.")
public class MetricMaximumParetoFrontError
implements InterfaceParetoFrontMetric,
Serializable {
    private PropertyFilePath inputFilePath = PropertyFilePath.getFilePathFromResource("MOPReference/T1_250.txt");
    private String[] titles;
    private double[][] reference;

    public MetricMaximumParetoFrontError() {
        this.loadReferenceData();
    }

    public MetricMaximumParetoFrontError(MetricMaximumParetoFrontError b) {
        if (b.titles != null) {
            this.titles = new String[b.titles.length];
            System.arraycopy(b.titles, 0, this.titles, 0, this.titles.length);
        }
        if (b.reference != null) {
            this.reference = new double[b.reference.length][b.reference[0].length];
            for (int i = 0; i < this.reference.length; ++i) {
                System.arraycopy(b.reference[i], 0, this.reference[i], 0, this.reference[i].length);
            }
        }
    }

    @Override
    public Object clone() {
        return new MetricMaximumParetoFrontError(this);
    }

    public void init() {
        this.loadReferenceData();
    }

    private void loadReferenceData() {
        int i;
        String[] lines = FileTools.loadStringsFromFile(this.inputFilePath.getCompleteFilePath());
        if (lines == null) {
            System.out.println("Failed to read " + this.inputFilePath.getCompleteFilePath());
        }
        lines[0].trim();
        this.titles = lines[0].split("\t");
        ArrayList<double[]> tmpA = new ArrayList<double[]>();
        for (i = 1; i < lines.length; ++i) {
            double[] tmpD = new double[this.titles.length];
            lines[i].trim();
            String[] tmpS = lines[i].split("\t");
            for (int j = 0; j < tmpD.length && j < tmpS.length; ++j) {
                tmpD[j] = Double.parseDouble(tmpS[j]);
            }
            tmpA.add(tmpD);
        }
        this.reference = new double[tmpA.size()][];
        for (i = 0; i < tmpA.size(); ++i) {
            this.reference[i] = (double[])tmpA.get(i);
        }
    }

    @Override
    public double calculateMetricOn(Population pop, AbstractMultiObjectiveOptimizationProblem problem) {
        double result = 0.0;
        Population tmpPPO = new Population();
        tmpPPO.addPopulation(pop);
        if (pop.getArchive() != null) {
            tmpPPO.addPopulation(pop.getArchive());
        }
        if (this.reference == null) {
            this.loadReferenceData();
            if (this.reference == null) {
                System.out.println("No reference data!");
                return 0.0;
            }
        }
        ArchivingAllDominating dom = new ArchivingAllDominating();
        dom.addElementsToArchive(tmpPPO);
        tmpPPO = tmpPPO.getArchive();
        result = Double.NEGATIVE_INFINITY;
        for (int j = 0; j < this.reference.length; ++j) {
            double min = Double.POSITIVE_INFINITY;
            for (int i = 0; i < tmpPPO.size(); ++i) {
                min = Math.min(min, this.distance(((AbstractEAIndividual)tmpPPO.get(i)).getFitness(), this.reference[j]));
            }
            result = Math.max(result, min);
        }
        return result;
    }

    private double distance(double[] d1, double[] d2) {
        double result = 0.0;
        for (int j = 0; j < d1.length && j < d2.length; ++j) {
            result += Math.pow(d1[j] - d2[j], 2.0);
        }
        return result;
    }

    public String getName() {
        return "Maximum Pareto Front Error";
    }

    public void setInputFilePath(PropertyFilePath b) {
        this.inputFilePath = b;
        this.loadReferenceData();
    }

    public PropertyFilePath getInputFilePath() {
        return this.inputFilePath;
    }

    public String inputFilePathTipText() {
        return "Select the reference soltuion by choosing the input file.";
    }
}

