/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.paretofrontmetrics;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.ESIndividualDoubleData;
import eva2.optimization.operator.archiving.ArchivingAllDominating;
import eva2.optimization.operator.paretofrontmetrics.InterfaceParetoFrontMetric;
import eva2.optimization.population.Population;
import eva2.problems.AbstractMultiObjectiveOptimizationProblem;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="Calculating the hypervolume UNDER the given Pareto-front.")
public class MetricS
implements InterfaceParetoFrontMetric,
Serializable {
    private double[][] objectiveSpaceRange;

    public MetricS() {
    }

    public MetricS(MetricS b) {
        if (b.objectiveSpaceRange != null) {
            this.objectiveSpaceRange = new double[b.objectiveSpaceRange.length][2];
            for (int i = 0; i < this.objectiveSpaceRange.length; ++i) {
                this.objectiveSpaceRange[i][0] = b.objectiveSpaceRange[i][0];
                this.objectiveSpaceRange[i][1] = b.objectiveSpaceRange[i][1];
            }
        }
    }

    @Override
    public Object clone() {
        return new MetricS(this);
    }

    public void setObjectiveSpaceRange(double[][] range) {
        this.objectiveSpaceRange = range;
    }

    public void init() {
    }

    @Override
    public double calculateMetricOn(Population pop, AbstractMultiObjectiveOptimizationProblem problem) {
        this.objectiveSpaceRange = problem.getObjectiveSpaceRange();
        double smetric = this.calculateSMetric(pop, this.objectiveSpaceRange, this.objectiveSpaceRange.length);
        double reference = 1.0;
        for (double[] anObjectiveSpaceRange : this.objectiveSpaceRange) {
            reference *= anObjectiveSpaceRange[1] - anObjectiveSpaceRange[0];
        }
        double res = Math.abs(smetric) / Math.abs(reference) * 100.0;
        return res;
    }

    public double calculateSMetric(Population pop, double[][] border, int dim) {
        int i;
        int i2;
        double result = 0.0;
        Population smPop = null;
        Population archive = pop.getArchive();
        if (archive == null || archive.size() == 0) {
            Population tmpPop = (Population)pop.getClone();
            ArchivingAllDominating tmpArch = new ArchivingAllDominating();
            tmpArch.addElementsToArchive(tmpPop);
            archive = tmpPop.getArchive();
        }
        if (dim == 1) {
            return pop.getBestFitness()[0];
        }
        if (dim > 2) {
            smPop = new Population();
        }
        double[][] f = new double[archive.size()][dim];
        for (i2 = 0; i2 < f.length; ++i2) {
            double[] tmpF = ((AbstractEAIndividual)archive.get(i2)).getFitness();
            System.arraycopy(tmpF, 0, f[i2], 0, dim);
            if (smPop == null) continue;
            double[] redF = new double[tmpF.length - 1];
            System.arraycopy(tmpF, 0, redF, 0, redF.length);
            ESIndividualDoubleData tmpIndy = new ESIndividualDoubleData();
            tmpIndy.setFitness(redF);
            smPop.add(i2, tmpIndy);
        }
        if (f.length < 1) {
            result = 1.0;
            for (i2 = 0; i2 < dim; ++i2) {
                result *= border[i2][1] - border[i2][0];
            }
            return result;
        }
        double[] lastValue = null;
        lastValue = new double[dim];
        for (i = 0; i < dim; ++i) {
            lastValue[i] = border[i][1];
        }
        lastValue[dim - 1] = border[dim - 1][0] - 1.0;
        for (i = 0; i < f.length; ++i) {
            int tmpIndex = 0;
            double tmpSmallest = Double.MAX_VALUE;
            for (int j = 0; j < f.length; ++j) {
                if (!(f[j][dim - 1] > lastValue[dim - 1]) || !(f[j][dim - 1] < tmpSmallest)) continue;
                tmpIndex = j;
                tmpSmallest = f[j][dim - 1];
            }
            if (f[tmpIndex][dim - 1] > lastValue[dim - 1]) {
                if (lastValue[dim - 1] < border[dim - 1][0]) {
                    lastValue[dim - 1] = border[dim - 1][0];
                }
                if (dim == 2) {
                    result += lastValue[0] * (f[tmpIndex][1] - lastValue[1]);
                } else {
                    int j;
                    Population tmpPop = new Population();
                    for (j = 0; j < archive.size(); ++j) {
                        if (!(((AbstractEAIndividual)archive.get(j)).getFitness(dim - 1) < f[tmpIndex][dim - 1])) continue;
                        tmpPop.add(smPop.get(j));
                    }
                    double[][] tmpBorder = new double[border.length - 1][2];
                    for (j = 0; j < tmpBorder.length; ++j) {
                        tmpBorder[j][0] = border[j][0];
                        tmpBorder[j][1] = border[j][1];
                    }
                    double tmpS = this.calculateSMetric(tmpPop, tmpBorder, dim - 1);
                    result += (f[tmpIndex][dim - 1] - lastValue[dim - 1]) * tmpS;
                }
            } else {
                i = f.length + 1;
                break;
            }
            System.arraycopy(f[tmpIndex], 0, lastValue, 0, f[tmpIndex].length);
        }
        if (dim == 2) {
            result += lastValue[0] * (border[1][1] - lastValue[1]);
        } else {
            int j;
            Population tmpPop = new Population();
            for (j = 0; j < archive.size(); ++j) {
                if (!(((AbstractEAIndividual)archive.get(j)).getFitness(dim - 1) <= lastValue[dim - 1])) continue;
                tmpPop.add(smPop.get(j));
            }
            double[][] tmpBorder = new double[border.length - 1][2];
            for (j = 0; j < tmpBorder.length; ++j) {
                tmpBorder[j][0] = border[j][0];
                tmpBorder[j][1] = border[j][1];
            }
            double tmpS = this.calculateSMetric(tmpPop, tmpBorder, dim - 1);
            result += (border[dim - 1][1] - lastValue[dim - 1]) * tmpS;
        }
        return result;
    }

    public String getName() {
        return "S-Metric";
    }
}

