/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.postprocess;

import eva2.OptimizerFactory;
import eva2.OptimizerRunnable;
import eva2.gui.BeanInspector;
import eva2.gui.plot.TopoPlot;
import eva2.optimization.InterfaceOptimizationParameters;
import eva2.optimization.OptimizationParameters;
import eva2.optimization.enums.ESMutationInitialSigma;
import eva2.optimization.enums.PostProcessMethod;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.ESIndividualDoubleData;
import eva2.optimization.individuals.IndividualInterface;
import eva2.optimization.individuals.InterfaceDataTypeDouble;
import eva2.optimization.individuals.InterfaceESIndividual;
import eva2.optimization.operator.cluster.ClusteringDensityBased;
import eva2.optimization.operator.cluster.InterfaceClustering;
import eva2.optimization.operator.crossover.CrossoverESDefault;
import eva2.optimization.operator.distancemetric.EuclideanMetric;
import eva2.optimization.operator.distancemetric.InterfaceDistanceMetric;
import eva2.optimization.operator.distancemetric.PhenotypeMetric;
import eva2.optimization.operator.mutation.InterfaceMutation;
import eva2.optimization.operator.mutation.MutateESFixedStepSize;
import eva2.optimization.operator.mutation.MutateESMutativeStepSizeControl;
import eva2.optimization.operator.mutation.MutateESRankMuCMA;
import eva2.optimization.operator.postprocess.InterfacePostProcessParams;
import eva2.optimization.operator.postprocess.SolutionHistogram;
import eva2.optimization.operator.selection.SelectBestIndividuals;
import eva2.optimization.operator.terminators.EvaluationTerminator;
import eva2.optimization.operator.terminators.InterfaceTerminator;
import eva2.optimization.population.Population;
import eva2.optimization.statistics.InterfaceStatisticsParameters;
import eva2.optimization.statistics.InterfaceTextListener;
import eva2.optimization.strategies.EvolutionStrategies;
import eva2.optimization.strategies.GradientDescentAlgorithm;
import eva2.optimization.strategies.HillClimbing;
import eva2.optimization.strategies.InterfaceOptimizer;
import eva2.optimization.strategies.NelderMeadSimplex;
import eva2.problems.AbstractOptimizationProblem;
import eva2.problems.FM0Problem;
import eva2.problems.Interface2DBorderProblem;
import eva2.problems.InterfaceHasSolutionViewer;
import eva2.problems.InterfaceInterestingHistogram;
import eva2.problems.InterfaceMultimodalProblemKnown;
import eva2.problems.InterfaceSolutionViewer;
import eva2.tools.Pair;
import eva2.tools.math.Mathematics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;

public class PostProcess {
    protected static InterfaceDistanceMetric metric = new PhenotypeMetric();
    private static double defaultMutationStepSize = 0.01;
    private static double minMutationStepSize = 1.0E-16;
    private static Vector<OptimizerRunnable> ppRunnables = new Vector();
    public static final String movedDistanceKey = "PostProcessingMovedBy";
    public static final String movedToPositionKey = "PostProcessingMovedTo";
    public static final int BEST_ONLY = 1;
    public static final int BEST_RAND = 2;
    public static final int RAND_ONLY = 3;
    public static final int KEEP_LONERS = 11;
    public static final int DISCARD_LONERS = 12;
    public static final int LONERS_AS_CLUSTERS = 13;

    public static AbstractEAIndividual[] getFoundOptimaArray(Population pop, Population optima, double epsilon, boolean bTakeFitter) {
        int i;
        AbstractEAIndividual[] found = new AbstractEAIndividual[optima.size()];
        for (i = 0; i < found.length; ++i) {
            found[i] = null;
        }
        for (i = 0; i < pop.size(); ++i) {
            AbstractEAIndividual candidate = (AbstractEAIndividual)pop.get(i);
            for (int j = 0; j < optima.size(); ++j) {
                AbstractEAIndividual opt = (AbstractEAIndividual)optima.get(j);
                double indDist = metric.distance(candidate, opt);
                if (found[j] == null) {
                    if (!(indDist < epsilon)) continue;
                    found[j] = (AbstractEAIndividual)candidate.clone();
                    continue;
                }
                if (!(indDist < epsilon) || (!bTakeFitter || !candidate.isDominatingDebConstraints(found[j])) && (bTakeFitter || !(indDist < metric.distance(found[j], opt)))) continue;
                found[j] = (AbstractEAIndividual)candidate.clone();
            }
        }
        return found;
    }

    public static Population getFoundOptima(Population pop, Population optima, double epsilon, boolean bTakeFitter) {
        Population result = new Population(5);
        AbstractEAIndividual[] optsFound = PostProcess.getFoundOptimaArray(pop, optima, epsilon, bTakeFitter);
        for (int i = 0; i < optsFound.length; ++i) {
            if (optsFound[i] == null) continue;
            result.add(optsFound[i]);
        }
        result.synchSize();
        return result;
    }

    public static Population clusterBest(Population pop, double sigmaCluster, double returnQuota, int lonerMode, int takeOverMode) {
        return PostProcess.clusterBest(pop, new ClusteringDensityBased(sigmaCluster, 2), returnQuota, lonerMode, takeOverMode);
    }

    public static Population clusterBest(Population pop, InterfaceClustering clustering, double returnQuota, int lonerMode, int takeOverMode) {
        Population result = new Population(10);
        result.setSameParams(pop);
        clustering.initClustering(pop);
        Population[] clusters = clustering.cluster(pop, null);
        block5: for (int j = 0; j < clusters.length; ++j) {
            if (j == 0) {
                if (lonerMode == 12) continue;
                if (lonerMode == 11) {
                    result.addAll(clusters[j]);
                    continue;
                }
                if (lonerMode != 13) {
                    System.err.println("invalid loner mode in (), default is treating them like clusters");
                }
            }
            if (returnQuota >= 1.0) {
                result.addAll(clusters[j]);
                continue;
            }
            int n = Math.max(1, (int)(returnQuota * (double)clusters[j].size()));
            switch (takeOverMode) {
                case 1: {
                    result.addAll(clusters[j].getBestNIndividuals(n, -1));
                    continue block5;
                }
                case 2: {
                    Population exclude = new Population();
                    exclude.add(clusters[j].getBestEAIndividual());
                    result.add(exclude.getEAIndividual(0));
                    result.addAll(clusters[j].moveRandNIndividualsExcept(n - 1, exclude));
                    continue block5;
                }
                case 3: {
                    result.addAll(clusters[j].moveRandNIndividuals(n));
                    continue block5;
                }
                default: {
                    System.err.println("Unknown mode in PostProcess:clusterBest!");
                }
            }
        }
        result.synchSize();
        return result;
    }

    public static double[] populationMeasures(Population pop) {
        double[] measures = pop.getPopulationMeasures();
        return measures;
    }

    public static Population filterFitnessIn(Population pop, double lower, double upper, int crit) {
        Population result = PostProcess.filterFitness(pop, upper, true, crit);
        return PostProcess.filterFitness(result, lower, false, crit);
    }

    public static Population filterFitnessNormed(Population pop, double fitNorm, boolean bSmallerEq) {
        Population result = new Population();
        for (int i = 0; i < pop.size(); ++i) {
            AbstractEAIndividual indy = pop.getEAIndividual(i);
            if (bSmallerEq && PhenotypeMetric.norm(indy.getFitness()) <= fitNorm) {
                result.add(indy);
                continue;
            }
            if (bSmallerEq || !(PhenotypeMetric.norm(indy.getFitness()) > fitNorm)) continue;
            result.add(indy);
        }
        return result;
    }

    public static Population filterFitness(Population pop, double fitThresh, boolean bSmallerEq, int crit) {
        Population result = new Population();
        for (int i = 0; i < pop.size(); ++i) {
            AbstractEAIndividual indy = pop.getEAIndividual(i);
            double curFit = crit >= 0 && crit < indy.getFitness().length ? indy.getFitness(crit) : PhenotypeMetric.norm(indy.getFitness());
            if (bSmallerEq && curFit <= fitThresh) {
                result.add(indy);
                continue;
            }
            if (bSmallerEq || !(curFit > fitThresh)) continue;
            result.add(indy);
        }
        return result;
    }

    public static Pair<Double, Integer> getClosestIndy(AbstractEAIndividual indy, Population pop) {
        double bestDist = -1.0;
        double tmpDist = -1.0;
        int bestIndex = -1;
        for (int j = 0; j < pop.size(); ++j) {
            AbstractEAIndividual opt = (AbstractEAIndividual)pop.get(j);
            tmpDist = metric.distance(indy, opt);
            if (!(bestDist < 0.0) && !(tmpDist < bestDist)) continue;
            bestIndex = j;
            bestDist = tmpDist;
        }
        return new Pair<Double, Integer>(bestDist, bestIndex);
    }

    public static int processWithHC(Population pop, AbstractOptimizationProblem problem, int maxSteps, double stepSize, double minStepSize) {
        int stepsBef = pop.getFunctionCalls();
        PostProcess.processWithHC(pop, problem, new EvaluationTerminator(pop.getFunctionCalls() + maxSteps), new MutateESMutativeStepSizeControl(stepSize, minStepSize, stepSize));
        return pop.getFunctionCalls() - stepsBef;
    }

    public static int processWithHC(Population pop, AbstractOptimizationProblem problem, int maxSteps) {
        return PostProcess.processWithHC(pop, problem, maxSteps, defaultMutationStepSize, minMutationStepSize);
    }

    public static void processWithHC(Population pop, AbstractOptimizationProblem problem, InterfaceTerminator term, InterfaceMutation mute) {
        HillClimbing hc = new HillClimbing();
        hc.setProblem(problem);
        mute.initialize(problem.getIndividualTemplate(), problem);
        hc.setMutationOperator(mute);
        if (pop.size() != pop.getTargetSize()) {
            System.err.println(pop.size() + " vs. " + pop.getTargetSize());
            System.err.println("warning: population size and vector size dont match! (PostProcess::processWithHC)");
        }
        hc.setPopulation(pop);
        OptimizerRunnable ppRunnable = new OptimizerRunnable((InterfaceOptimizationParameters)OptimizerFactory.makeParams((InterfaceOptimizer)hc, pop, problem, 0L, term), true);
        PostProcess.runPP(ppRunnable);
    }

    public static int processWithGDA(Population pop, AbstractOptimizationProblem problem, InterfaceTerminator term, int baseEvals, double minStepSize, double maxStepSize) {
        GradientDescentAlgorithm gda = new GradientDescentAlgorithm();
        gda.setAdaptStepSizeLocally(true);
        gda.setProblem(problem);
        gda.setLocalMinStepSize(minStepSize);
        gda.setLocalMaxStepSize(maxStepSize);
        gda.setRecovery(false);
        gda.initializeByPopulation(pop, false);
        int funCallsBefore = pop.getFunctionCalls();
        pop.setFunctionCalls(baseEvals);
        OptimizerRunnable ppRunnable = new OptimizerRunnable((InterfaceOptimizationParameters)OptimizerFactory.makeParams((InterfaceOptimizer)gda, pop, problem, 0L, term), true);
        PostProcess.runPP(ppRunnable);
        int funCallsDone = pop.getFunctionCalls() - baseEvals;
        pop.setFunctionCalls(funCallsBefore);
        return funCallsDone;
    }

    public static Pair<Integer, Boolean> processWithNMS(Population pop, AbstractOptimizationProblem problem, InterfaceTerminator term, int baseEvals) {
        NelderMeadSimplex nms = new NelderMeadSimplex();
        nms.setProblemAndPopSize(problem);
        nms.setGenerationCycle(5);
        nms.initializeByPopulation(pop, false);
        int funCallsBefore = pop.getFunctionCalls();
        pop.setFunctionCalls(baseEvals);
        OptimizerRunnable ppRunnable = new OptimizerRunnable((InterfaceOptimizationParameters)OptimizerFactory.makeParams((InterfaceOptimizer)nms, pop, problem, 0L, term), true);
        ppRunnable.getStats().createNextGenerationPerformed(nms.getPopulation(), nms, null);
        PostProcess.runPP(ppRunnable);
        int funCallsDone = pop.getFunctionCalls() - baseEvals;
        pop.setFunctionCalls(funCallsBefore);
        return new Pair<Integer, Boolean>(funCallsDone, ppRunnable.wasAborted());
    }

    public static Pair<Integer, Boolean> processWithCMA(Population pop, AbstractOptimizationProblem problem, InterfaceTerminator term, int baseEvals) {
        MutateESRankMuCMA mutator = new MutateESRankMuCMA();
        mutator.setInitializeSigma(ESMutationInitialSigma.avgInitialDistance);
        EvolutionStrategies es = OptimizerFactory.createEvolutionStrategy(pop.size() / 2, pop.size(), false, mutator, 1.0, new CrossoverESDefault(), 0.0, new SelectBestIndividuals(), problem, null);
        for (int i = 0; i < pop.size(); ++i) {
            pop.getEAIndividual(i).initCloneOperators(mutator, 1.0, new CrossoverESDefault(), 0.0, problem);
        }
        es.initializeByPopulation(pop, false);
        OptimizationParameters cmaParams = OptimizerFactory.makeParams((InterfaceOptimizer)es, pop, problem, 0L, term);
        int funCallsBefore = pop.getFunctionCalls();
        pop.setFunctionCalls(baseEvals);
        OptimizerRunnable ppRunnable = new OptimizerRunnable((InterfaceOptimizationParameters)cmaParams, true);
        ppRunnable.getStats().createNextGenerationPerformed(cmaParams.getOptimizer().getPopulation(), cmaParams.getOptimizer(), null);
        PostProcess.runPP(ppRunnable);
        pop.clear();
        pop.addPopulation(es.getPopulation());
        int funCallsDone = es.getPopulation().getFunctionCalls() - baseEvals;
        pop.setFunctionCalls(funCallsBefore);
        return new Pair<Integer, Boolean>(funCallsDone, ppRunnable.wasAborted());
    }

    private static boolean checkRange(AbstractEAIndividual indy) {
        InterfaceDataTypeDouble idd = (InterfaceDataTypeDouble)((Object)indy);
        return Mathematics.isInRange(idd.getDoubleData(), idd.getDoubleRange());
    }

    public static Pair<AbstractEAIndividual, Integer> localSolverNMS(AbstractEAIndividual cand, int hcSteps, double initPerturbation, AbstractOptimizationProblem prob) {
        Population pop = new Population(1);
        pop.add(cand);
        int evalsDone = PostProcess.processSingleCandidates(PostProcessMethod.nelderMead, pop, hcSteps, initPerturbation, prob, null);
        return new Pair<AbstractEAIndividual, Integer>(pop.getBestEAIndividual(), evalsDone);
    }

    public static Population createLSSupPopulation(PostProcessMethod method, AbstractOptimizationProblem problem, Population candidates, int index, double maxRelativePerturbation, boolean includeCand) {
        Population subPop = null;
        switch (method) {
            case cmaES: {
                subPop = new Population();
                PostProcess.createPopInSubRange(subPop, maxRelativePerturbation, PostProcess.getDefCMAPopSize(candidates.getEAIndividual(index)) - 1, candidates.getEAIndividual(index));
                break;
            }
            case hillClimber: {
                System.err.println("INVALID in createLSSupPopulation");
                break;
            }
            case nelderMead: {
                double[][] range = ((InterfaceDataTypeDouble)((Object)candidates.getEAIndividual(index))).getDoubleRange();
                double perturb = PostProcess.findNMSPerturb(candidates, index, PostProcess.relToAbsPerturb(maxRelativePerturbation, range));
                subPop = NelderMeadSimplex.createNMSPopulation(candidates.getEAIndividual(index), PostProcess.absToRelPerturb(perturb, range), range, false);
            }
        }
        return subPop;
    }

    public static double relToAbsPerturb(double maxRelativePerturbation, double[][] range) {
        return maxRelativePerturbation * Mathematics.getAvgRange(range);
    }

    public static double absToRelPerturb(double maxAbsPerturbation, double[][] range) {
        return maxAbsPerturbation / Mathematics.getAvgRange(range);
    }

    private static int getDefCMAPopSize(AbstractEAIndividual template) {
        if (PostProcess.isDoubleCompliant(template)) {
            double[][] range = PostProcess.getDoubleRange(template);
            int targetSize = (int)(4.0 + 3.0 * Math.log(range.length));
            return targetSize;
        }
        System.err.println("Warning, invalid individual for PostProcess.getDefCMAPopSize");
        return 10;
    }

    public static int processSingleCandidates(PostProcessMethod method, Population candidates, int steps, double maxPerturbation, AbstractOptimizationProblem prob, InterfaceMutation mute) {
        int dim = ((InterfaceDataTypeDouble)((Object)candidates.getEAIndividual(0))).getDoubleRange().length;
        int candCnt = candidates.size();
        if (method == PostProcessMethod.hillClimber) {
            int evalsOld = candidates.getFunctionCalls();
            PostProcess.processWithHC(candidates, prob, new EvaluationTerminator(evalsOld + steps), mute);
            int evalsDone = candidates.getFunctionCalls() - evalsOld;
            candidates.setFunctionCalls(evalsOld);
            return evalsDone;
        }
        int stepsPerCand = (steps - candCnt * (dim - 1)) / candCnt;
        if (stepsPerCand < dim) {
            System.err.println("Too few steps allowed in processSingleCandidates!");
            System.err.println("Method: " + (Object)((Object)method) + ", cands: " + candidates.size() + ", steps: " + steps);
            return 0;
        }
        EvaluationTerminator term = new EvaluationTerminator(stepsPerCand);
        return PostProcess.processSingleCandidatesNMCMA(method, candidates, term, maxPerturbation, prob);
    }

    public static int processSingleCandidatesNMCMA(PostProcessMethod method, Population candidates, InterfaceTerminator term, double maxRelativePerturbation, AbstractOptimizationProblem prob) {
        Population subPop;
        ArrayList<Population> nmPops = new ArrayList<Population>();
        int stepsPerf = 0;
        for (int i = 0; i < candidates.size(); ++i) {
            subPop = PostProcess.createLSSupPopulation(method, prob, candidates, i, maxRelativePerturbation, false);
            prob.evaluate(subPop);
            stepsPerf += subPop.size();
            subPop.add((AbstractEAIndividual)candidates.getEAIndividual(i).clone());
            nmPops.add(subPop);
        }
        if (term == null) {
            int stepsPerCand = 10 * (((Population)nmPops.get(0)).size() - 1);
            if (stepsPerCand < 1) {
                System.err.println("Too few steps allowed!");
                return 0;
            }
            term = new EvaluationTerminator(stepsPerCand);
        }
        Pair<Integer, Boolean> stepsAbortedFlag = null;
        for (int i = 0; i < candidates.size(); ++i) {
            subPop = (Population)nmPops.get(i);
            term.initialize(prob);
            switch (method) {
                case nelderMead: {
                    stepsAbortedFlag = PostProcess.processWithNMS(subPop, prob, term, subPop.size() - 1);
                    break;
                }
                case cmaES: {
                    stepsAbortedFlag = PostProcess.processWithCMA(subPop, prob, term, subPop.size() - 1);
                    break;
                }
                default: {
                    System.err.println("Invalid pp method in processSingleCandidatesNMCMA!");
                }
            }
            if (stepsAbortedFlag == null) {
                System.err.println("Error in processSingleCandidatesNMCMA!");
            }
            stepsPerf += ((Integer)stepsAbortedFlag.head).intValue();
            if (((Boolean)stepsAbortedFlag.tail).booleanValue()) {
                System.err.println("Warning: Post processing interrupted after " + i + " of " + candidates.size() + " candidates were processed.");
                break;
            }
            if (PostProcess.checkRange(subPop.getBestEAIndividual())) {
                if (!(subPop.getBestEAIndividual().getFitness(0) < candidates.getEAIndividual(i).getFitness(0))) continue;
                subPop.getBestEAIndividual().putData(movedDistanceKey, PhenotypeMetric.dist(candidates.getEAIndividual(i), subPop.getBestEAIndividual()));
                candidates.set(i, subPop.getBestEAIndividual());
                continue;
            }
            System.err.println("Warning, individual left the problem range during PP!");
        }
        return stepsPerf;
    }

    public static boolean isDoubleCompliant(AbstractEAIndividual indy) {
        return indy instanceof InterfaceDataTypeDouble || indy instanceof InterfaceESIndividual;
    }

    public static double[][] getDoubleRange(AbstractEAIndividual indy) {
        if (indy instanceof InterfaceDataTypeDouble || indy instanceof InterfaceESIndividual) {
            if (indy instanceof InterfaceESIndividual) {
                return ((InterfaceESIndividual)((Object)indy)).getDoubleRange();
            }
            return ((InterfaceDataTypeDouble)((Object)indy)).getDoubleRange();
        }
        return null;
    }

    public static double[] getDoubleData(AbstractEAIndividual indy) {
        if (indy instanceof InterfaceDataTypeDouble || indy instanceof InterfaceESIndividual) {
            if (indy instanceof InterfaceESIndividual) {
                return ((InterfaceESIndividual)((Object)indy)).getDGenotype();
            }
            return ((InterfaceDataTypeDouble)((Object)indy)).getDoubleData();
        }
        return null;
    }

    public static void setDoubleData(AbstractEAIndividual indy, double[] data) {
        if (indy instanceof InterfaceDataTypeDouble || indy instanceof InterfaceESIndividual) {
            if (indy instanceof InterfaceESIndividual) {
                ((InterfaceESIndividual)((Object)indy)).setDGenotype(data);
            } else {
                ((InterfaceDataTypeDouble)((Object)indy)).setDoubleGenotype(data);
            }
        } else {
            throw new RuntimeException("Error, unable to set double data to individual instance " + indy.getClass() + " in PostProcess.setDoubleData");
        }
    }

    public static void createPopInSubRange(Population destPop, double searchBoxLen, int targetSize, AbstractEAIndividual indy) {
        if (PostProcess.isDoubleCompliant(indy)) {
            double[][] range = PostProcess.getDoubleRange(indy);
            double[] data = PostProcess.getDoubleData(indy);
            double[][] newRange = new double[range.length][2];
            for (int dim = 0; dim < range.length; ++dim) {
                newRange[dim][0] = Math.max(range[dim][0], data[dim] - searchBoxLen / 2.0);
                newRange[dim][1] = Math.min(range[dim][1], data[dim] + searchBoxLen / 2.0);
            }
            destPop.clear();
            for (int i = 0; i < targetSize; ++i) {
                destPop.addIndividual(PostProcess.createRandomDoubleClone(indy, newRange));
            }
            destPop.synchSize();
        } else {
            System.err.println("invalid individual type!");
        }
    }

    public static AbstractEAIndividual createRandomDoubleClone(AbstractEAIndividual indy, double[][] range) {
        AbstractEAIndividual tmpIndy = (AbstractEAIndividual)indy.clone();
        double[] data = PostProcess.getDoubleData(tmpIndy);
        if (data == null) {
            throw new RuntimeException("Error, given individual must be double compliant in PostProcess.createRandomDoubleClone");
        }
        ESIndividualDoubleData.defaultInit(data, range);
        PostProcess.setDoubleData(tmpIndy, data);
        return tmpIndy;
    }

    private static void runPP(OptimizerRunnable rnbl) {
        rnbl.getOptimizationParameters().setDoPostProcessing(false);
        rnbl.setVerbosityLevel(InterfaceStatisticsParameters.OutputVerbosity.NONE);
        ppRunnables.add(rnbl);
        rnbl.run();
        rnbl.getOptimizationParameters().setDoPostProcessing(true);
        ppRunnables.remove(rnbl);
    }

    public static void stopPP(int rnblID) {
        OptimizerRunnable rnbl = PostProcess.getRunnable(rnblID);
        PostProcess.stopPP(rnbl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static OptimizerRunnable getRunnable(int rnblID) {
        Vector<OptimizerRunnable> vector = ppRunnables;
        synchronized (vector) {
            for (OptimizerRunnable ppRunnable : ppRunnables) {
                if (rnblID != ppRunnable.getID()) continue;
                return ppRunnable;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopPP(OptimizerRunnable rnbl) {
        if (rnbl != null) {
            OptimizerRunnable optimizerRunnable = rnbl;
            synchronized (optimizerRunnable) {
                rnbl.stopOpt();
            }
        }
    }

    private static TopoPlot draw(String title, TopoPlot plot, Population popBef, Population popAft, AbstractOptimizationProblem prob) {
        InterfaceDataTypeDouble tmpIndy1;
        double[][] range = ((InterfaceDataTypeDouble)((Object)popBef.getEAIndividual(0))).getDoubleRange();
        if (plot == null) {
            plot = new TopoPlot("PostProcessing: " + title, "x", "y", range[0], range[1]);
            if (prob instanceof Interface2DBorderProblem) {
                plot.setParams(60, 60);
                plot.setTopology((Interface2DBorderProblem)((Object)prob));
            }
        } else {
            plot.clearAll();
        }
        for (int i = 0; i < popBef.size(); ++i) {
            tmpIndy1 = (InterfaceDataTypeDouble)popBef.get(i);
            plot.getFunctionArea().drawCircle(popBef.getEAIndividual(i).getFitness(0), tmpIndy1.getDoubleData(), 0);
        }
        if (popAft != null) {
            plot.getFunctionArea().setGraphColor(0, 2);
            for (int i = 0; i < popAft.size(); ++i) {
                tmpIndy1 = (InterfaceDataTypeDouble)popBef.get(i);
                InterfaceDataTypeDouble tmpIndy2 = (InterfaceDataTypeDouble)popAft.get(i);
                plot.getFunctionArea().drawCircle(popAft.getEAIndividual(i).getFitness(0), tmpIndy2.getDoubleData(), 0);
                plot.getFunctionArea().setConnectedPoint(tmpIndy1.getDoubleData(), i + 1);
                plot.getFunctionArea().setConnectedPoint(tmpIndy2.getDoubleData(), i + 1);
                plot.getFunctionArea().setGraphColor(i + 1, 0);
            }
        }
        return plot;
    }

    public static void main(String[] args) {
        FM0Problem problem = new FM0Problem();
        InterfaceMultimodalProblemKnown mmp = problem;
        OptimizerRunnable runnable = OptimizerFactory.getOptRunnable(3, (AbstractOptimizationProblem)problem, 100, null);
        runnable.run();
        Population pop = runnable.getOptimizationParameters().getOptimizer().getPopulation();
        Population found = PostProcess.getFoundOptima(pop, mmp.getRealOptima(), 0.05, true);
        System.out.println("all found (" + found.size() + "): " + BeanInspector.toString(found));
        Pair<Population, Double> popD = new Pair<Population, Double>(pop, 1.0);
        int i = 0;
        int evalCnt = 0;
        while (popD.tail() > 0.001) {
            ++i;
            popD = PostProcess.clusterLocalSearch(PostProcessMethod.hillClimber, popD.head(), problem, 0.01, 1500, 0.1, new MutateESFixedStepSize(0.02));
            evalCnt += popD.head().getFunctionCalls();
            System.out.println("popsize is " + popD.head().size());
        }
        found = PostProcess.getFoundOptima(popD.head(), mmp.getRealOptima(), 0.05, true);
        System.out.println("found at " + i + " (" + found.size() + "): " + BeanInspector.toString(found));
        System.out.println("funcalls: " + evalCnt);
    }

    public static Pair<Population, Double> clusterLocalSearch(PostProcessMethod method, Population pop, AbstractOptimizationProblem problem, double sigmaCluster, int funCalls, double keepClusterRatio, InterfaceMutation mute) {
        int evalsBefore = pop.getFunctionCalls();
        Population clust = (Population)PostProcess.clusterBest(pop, new ClusteringDensityBased(sigmaCluster, 2), keepClusterRatio, 11, 2).clone();
        double[] meanFit = clust.getMeanFitness();
        int evalsDone = PostProcess.processSingleCandidates(method, clust, funCalls, sigmaCluster / 2.0, problem, mute);
        clust.setFunctionCalls(evalsBefore + evalsDone);
        double improvement = EuclideanMetric.euclideanDistance(meanFit, clust.getMeanFitness());
        return new Pair<Population, Double>(clust, improvement);
    }

    public static void evaluateMultiModal(Population solutions, AbstractOptimizationProblem prob, InterfaceTextListener listener) {
        if (listener == null) {
            return;
        }
        if (prob instanceof InterfaceMultimodalProblemKnown) {
            InterfaceMultimodalProblemKnown mmkProb = (InterfaceMultimodalProblemKnown)((Object)prob);
            listener.println("number of known optima is " + mmkProb.getRealOptima().size());
            listener.println("default epsilon is " + mmkProb.getDefaultAccuracy());
            listener.println("optima found with default epsilon: " + PostProcess.getFoundOptima(solutions, mmkProb.getRealOptima(), mmkProb.getDefaultAccuracy(), true).size());
            listener.println("max peak ratio is " + mmkProb.getMaximumPeakRatio(PostProcess.getFoundOptima(solutions, mmkProb.getRealOptima(), mmkProb.getDefaultAccuracy(), true)));
            if (mmkProb.fullListAvailable()) {
                for (double epsilon = 0.1; epsilon > 1.0E-8; epsilon /= 10.0) {
                    listener.println("found " + PostProcess.getFoundOptima(solutions, mmkProb.getRealOptima(), epsilon, true).size() + " for epsilon = " + epsilon + ", maxPeakRatio: " + mmkProb.getMaximumPeakRatio(solutions));
                }
            }
        }
    }

    public static Population clusterBestUpdateHistogram(Population pop, AbstractOptimizationProblem prob, SolutionHistogram hist, int crit, double accuracy) {
        Population opts = PostProcess.clusterBest(pop, accuracy, 0.0, 11, 1);
        hist.updateFrom(opts, crit);
        return opts;
    }

    public static Population postProcess(InterfacePostProcessParams params, Population inputPop, AbstractOptimizationProblem problem, InterfaceTextListener listener) {
        if (params.isDoPostProcessing() && inputPop != null) {
            InterfaceSolutionViewer viewer;
            Population outputPop;
            TopoPlot topoPlot;
            Population clusteredPop;
            if (params.getPostProcessClusterSigma() > 0.0) {
                clusteredPop = (Population)PostProcess.clusterBest(inputPop, params.getPostProcessClusterSigma(), 0.0, 11, 1).clone();
                if (clusteredPop.size() < inputPop.size()) {
                    if (listener != null) {
                        listener.println("Initial clustering reduced population size from " + inputPop.size() + " to " + clusteredPop.size());
                    }
                } else if (listener != null) {
                    listener.println("Initial clustering yielded no size reduction.");
                }
            } else {
                clusteredPop = inputPop;
            }
            int stepsDone = 0;
            if (params.getPostProcessSteps() > 0) {
                double stepSize = PostProcess.selectMaxSearchRange(params.getPPMethod(), params.getPostProcessClusterSigma());
                Population stateBeforeLS = (Population)clusteredPop.clone();
                MutateESMutativeStepSizeControl mutator = params.getPPMethod() == PostProcessMethod.hillClimber ? new MutateESMutativeStepSizeControl(stepSize, minMutationStepSize, stepSize) : null;
                stepsDone = PostProcess.processSingleCandidates(params.getPPMethod(), clusteredPop, params.getPostProcessSteps(), stepSize, problem, mutator);
                if (listener != null) {
                    listener.println("Post processing: " + stepsDone + " steps done.");
                }
                if (params.isWithPlot()) {
                    topoPlot = PostProcess.draw("After " + stepsDone + " steps (" + (Object)((Object)params.getPPMethod()) + ")", null, stateBeforeLS, clusteredPop, problem);
                }
                if (params.getPostProcessClusterSigma() > 0.0) {
                    outputPop = (Population)PostProcess.clusterBest(clusteredPop, params.getPostProcessClusterSigma(), 0.0, 11, 1).clone();
                    if (outputPop.size() < clusteredPop.size()) {
                        if (listener != null) {
                            listener.println("Second clustering reduced population size from " + clusteredPop.size() + " to " + outputPop.size());
                        }
                    } else if (listener != null) {
                        listener.println("Second clustering yielded no size reduction.");
                    }
                } else {
                    outputPop = clusteredPop;
                }
            } else {
                outputPop = clusteredPop;
            }
            if (params.isWithPlot()) {
                topoPlot = PostProcess.draw("After " + stepsDone + " steps (" + (Object)((Object)params.getPPMethod()) + ")" + (params.getPostProcessClusterSigma() > 0.0 ? " and second clustering" : ""), null, outputPop, null, problem);
            }
            double upBnd = PhenotypeMetric.norm(outputPop.getWorstEAIndividual().getFitness()) * 1.1;
            upBnd = Math.pow(10.0, Math.floor(Math.log10(upBnd) + 1.0));
            double lowBnd = 0.0;
            int fitCrit = 0;
            SolutionHistogram solHist = SolutionHistogram.createFitNormHistogram(outputPop, lowBnd, upBnd, 20, fitCrit);
            if (outputPop.size() > 1) {
                if (listener != null) {
                    listener.println("measures: " + BeanInspector.toString(outputPop.getPopulationMeasures()));
                }
                if (listener != null) {
                    listener.println("pop.metric: " + BeanInspector.toString(outputPop.getPopMetric()));
                }
                if (listener != null) {
                    listener.println("solution histogram: " + solHist + ", score " + solHist.getScore());
                }
                if (listener != null && problem instanceof InterfaceInterestingHistogram) {
                    SolutionHistogram pSolHist = ((InterfaceInterestingHistogram)((Object)problem)).getHistogram();
                    pSolHist.updateFrom(outputPop, fitCrit);
                    listener.println("problem-defined histogram: " + pSolHist + ", score " + pSolHist.getScore());
                }
            }
            PostProcess.evaluateMultiModal(outputPop, problem, listener);
            Population nBestPop = outputPop.getBestNIndividuals(0, -1);
            if (params.getPrintNBest() != 0) {
                int printK = params.getPrintNBest() > 0 ? params.getPrintNBest() : nBestPop.size();
                printK = Math.min(printK, nBestPop.size());
                if (listener != null) {
                    listener.println("Best after post process: (first " + printK + " of " + outputPop.size() + ")");
                }
                if (listener != null) {
                    for (int i = 0; i < printK; ++i) {
                        listener.println(AbstractEAIndividual.getDefaultStringRepresentation(nBestPop.getEAIndividual(i)));
                    }
                }
            }
            if (problem instanceof InterfaceHasSolutionViewer && (viewer = ((InterfaceHasSolutionViewer)((Object)problem)).getSolutionViewer()) != null) {
                viewer.initView(problem);
                viewer.updateView(outputPop, true);
            }
            return nBestPop;
        }
        return inputPop;
    }

    public static int[] checkAccuracy(AbstractOptimizationProblem prob, Population sols, double[] epsilonPhenoSpace, double extrOptEpsFitConf, double extrOptClustSig, int maxEvals, SolutionHistogram[] solHists, boolean treatAsUnknown, InterfaceTextListener listener) {
        int[] foundOpts = new int[epsilonPhenoSpace.length];
        Population extrOpts = null;
        if (listener != null) {
            listener.println("Accuracy regarding epsilon thresholds " + BeanInspector.toString(epsilonPhenoSpace));
        }
        for (int k = 0; k < epsilonPhenoSpace.length; ++k) {
            int i;
            if (prob instanceof InterfaceMultimodalProblemKnown && !treatAsUnknown) {
                extrOpts = PostProcess.getFoundOptima(k == 0 ? sols : extrOpts, ((InterfaceMultimodalProblemKnown)((Object)prob)).getRealOptima(), epsilonPhenoSpace[k], true);
            } else {
                double clustSig;
                double d = clustSig = extrOptClustSig < 0.0 ? 0.1 * epsilonPhenoSpace[k] : extrOptClustSig;
                if (listener != null) {
                    listener.println("clustering with sigma=" + clustSig);
                }
                extrOpts = AbstractOptimizationProblem.extractPotentialOptima(prob, k == 0 ? sols : extrOpts, epsilonPhenoSpace[k], extrOptEpsFitConf, clustSig, maxEvals);
            }
            String prefix = "crit " + epsilonPhenoSpace[k];
            if (listener != null) {
                listener.print(prefix + " found " + extrOpts.size());
            }
            foundOpts[k] = extrOpts.size();
            if (treatAsUnknown || !(prob instanceof InterfaceMultimodalProblemKnown)) {
                SolutionHistogram curHist = null;
                SolutionHistogram lastHist = SolutionHistogram.defaultEmptyHistogram(prob);
                curHist = solHists != null ? solHists[k].cloneEmpty() : SolutionHistogram.defaultEmptyHistogram(prob);
                lastHist.updateFrom(sols, 0);
                curHist.updateFrom(extrOpts, 0);
                if (listener != null) {
                    listener.println(", histogram: " + curHist);
                }
                if (solHists != null) {
                    if (solHists[k] != null) {
                        solHists[k].addHistogram(curHist);
                    } else {
                        solHists[k] = curHist;
                    }
                }
            }
            if (extrOpts.size() <= 0) continue;
            if (listener != null) {
                listener.print(" measures fit: ");
            }
            int critCnt = extrOpts.getEAIndividual(0).getFitness().length;
            for (i = 0; i < critCnt; ++i) {
                if (listener == null) continue;
                listener.print(BeanInspector.toString(extrOpts.getFitnessMeasures(i)) + " ");
            }
            if (extrOpts.size() > 1) {
                if (listener != null) {
                    listener.print("; phen: " + BeanInspector.toString(extrOpts.getPopulationMeasures(new PhenotypeMetric())));
                }
                if (listener != null) {
                    listener.print("; eucl: " + BeanInspector.toString(extrOpts.getPopulationMeasures(new EuclideanMetric())));
                }
                if (listener != null) {
                    listener.print("; popMetric: " + BeanInspector.toString(extrOpts.getPopulationMeasures()));
                }
            }
            if (listener != null) {
                listener.println("");
            }
            for (i = 16; i > 2; i /= 2) {
                Population bestN = extrOpts.getBestNIndividuals(i, -1);
                listener.println(" phen. measures of top " + bestN.size() + ": " + BeanInspector.toString(bestN.getPopulationMeasures(new PhenotypeMetric())));
            }
        }
        return foundOpts;
    }

    private static double selectMaxSearchRange(PostProcessMethod method, double postProcessClusterSigma) {
        double resolution = defaultMutationStepSize * 2.0;
        if (postProcessClusterSigma > 0.0) {
            resolution = postProcessClusterSigma;
        }
        switch (method) {
            case hillClimber: {
                return resolution / 2.0;
            }
            case nelderMead: {
                return resolution / 3.0;
            }
            default: {
                System.err.println("Invalid method!");
            }
            case cmaES: 
        }
        return resolution;
    }

    public static double findNMSPerturb(Population candidates, int i, double maxAbsPerturb) {
        double minDistNeighbour = Double.MAX_VALUE;
        AbstractEAIndividual indy = candidates.getEAIndividual(i);
        boolean found = false;
        for (int k = 0; k < candidates.size(); ++k) {
            double dist;
            if (k == i || (dist = EuclideanMetric.euclideanDistance(AbstractEAIndividual.getDoublePositionShallow(indy), AbstractEAIndividual.getDoublePositionShallow(candidates.getEAIndividual(k)))) == 0.0 || !(dist < minDistNeighbour)) continue;
            minDistNeighbour = dist;
            found = true;
        }
        if (!found) {
            if (maxAbsPerturb > 0.0) {
                return maxAbsPerturb;
            }
            System.err.println("error, unable to select perturbance value in PostProcess.findNMSPerturb since all candidates are equal. Converged population?!");
            return 0.01;
        }
        if (maxAbsPerturb > 0.0) {
            return Math.min(maxAbsPerturb, minDistNeighbour / 3.0);
        }
        return minDistNeighbour / 3.0;
    }

    public static double[] calcAvgRandomFunctionValue(int steps, AbstractOptimizationProblem prob) {
        int cnt = 0;
        int portion = 100;
        int curPopSize = Math.min(portion, steps);
        double[] portionFitSum = null;
        double[] avgFit = null;
        Population pop = new Population(portion);
        prob.initializeProblem();
        while (cnt < steps) {
            int i;
            pop.clear();
            for (i = 0; i < curPopSize; ++i) {
                IndividualInterface indy = prob.getIndividualTemplate().getClone();
                indy.defaultInit(prob);
                pop.add(indy);
            }
            pop.synchSize();
            prob.evaluate(pop);
            if (portionFitSum == null) {
                portionFitSum = new double[pop.getEAIndividual(0).getFitness().length];
                avgFit = new double[portionFitSum.length];
                Arrays.fill(avgFit, 0.0);
            }
            Arrays.fill(portionFitSum, 0.0);
            for (i = 0; i < curPopSize; ++i) {
                Mathematics.vvAdd(portionFitSum, pop.getEAIndividual(i).getFitness(), portionFitSum);
            }
            Mathematics.svvAddScaled(1.0 / (double)steps, portionFitSum, avgFit, avgFit);
            curPopSize = Math.min(portion, steps - (cnt += curPopSize));
        }
        return avgFit;
    }

    public static double getAvgDistToNeighbor(int index, Population pop) {
        double distSum = 0.0;
        int cnt = pop.size() - 1;
        if (cnt == 0) {
            return 0.0;
        }
        double[] indyPos = AbstractEAIndividual.getDoublePositionShallow(pop.getEAIndividual(index));
        for (int i = 0; i < pop.size(); ++i) {
            if (i == index) continue;
            distSum += EuclideanMetric.euclideanDistance(AbstractEAIndividual.getDoublePositionShallow(pop.getEAIndividual(i)), indyPos);
        }
        return distSum / (double)cnt;
    }

    public static double calcQualityMeasure(int avgFitSteps, Population solutions, int criterion, AbstractOptimizationProblem problem) {
        int solCnt = solutions.size();
        double indyScore = 0.0;
        double scoreSum = 0.0;
        double[] avgFit = PostProcess.calcAvgRandomFunctionValue(avgFitSteps, problem);
        for (int i = 0; i < solCnt; ++i) {
            double indyQual = avgFit[criterion] - solutions.getEAIndividual(i).getFitness(criterion);
            double indyAvgDist = PostProcess.getAvgDistToNeighbor(i, solutions);
            indyScore = Math.pow(indyQual, 2.0) + Math.pow(1.0 + indyAvgDist, 2.0);
            scoreSum += indyScore;
        }
        return Math.sqrt(scoreSum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopAllPP() {
        Vector<OptimizerRunnable> vector = ppRunnables;
        synchronized (vector) {
            ppRunnables.forEach(OptimizerRunnable::stopOpt);
        }
    }
}

