/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.postprocess;

import eva2.gui.editor.GenericObjectEditor;
import eva2.optimization.enums.PostProcessMethod;
import eva2.optimization.operator.postprocess.InterfacePostProcessParams;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="Combined clustering and local search post-processing of solutions. Additionally, accuracy checks can be performed on the returned solutions with different thresholds.")
public class PostProcessParams
implements InterfacePostProcessParams,
Serializable {
    protected int postProcessSteps = 5000;
    private boolean postProcess = false;
    protected double postProcessClusterSigma = 0.05;
    protected int printNBest = 10;
    protected PostProcessMethod method = PostProcessMethod.nelderMead;
    protected double[] accuracies = new double[]{0.01};
    protected double accAssumeConv = 1.0E-8;
    protected int accMaxEval = -1;
    private boolean withPlot = false;

    public PostProcessParams() {
        this.postProcessSteps = 5000;
        this.postProcess = false;
        this.postProcessClusterSigma = 0.05;
        this.printNBest = 10;
    }

    public PostProcessParams(boolean doPP) {
        this.postProcessSteps = 5000;
        this.postProcess = doPP;
        this.postProcessClusterSigma = 0.05;
    }

    public PostProcessParams(int steps, double clusterSigma) {
        this(steps, clusterSigma, 10);
    }

    public PostProcessParams(int steps, double clusterSigma, int nBest) {
        this.postProcessSteps = steps;
        this.postProcess = true;
        this.postProcessClusterSigma = clusterSigma;
        this.printNBest = nBest;
    }

    public PostProcessParams(PostProcessMethod meth, int steps, double clusterSigma, int nBest) {
        this.reset(meth, steps, clusterSigma, nBest, false);
    }

    public PostProcessParams(PostProcessMethod meth, int steps, double clusterSigma, int nBest, boolean doPlot) {
        this.reset(meth, steps, clusterSigma, nBest, doPlot);
    }

    public PostProcessParams reset(PostProcessMethod meth, int steps, double clusterSigma, int nBest, boolean doPlot) {
        this.method = meth;
        this.postProcessSteps = steps;
        this.postProcess = true;
        this.postProcessClusterSigma = clusterSigma;
        this.printNBest = nBest;
        this.withPlot = doPlot;
        return this;
    }

    public void hideHideable() {
        this.setDoPostProcessing(this.isDoPostProcessing());
    }

    @Override
    public boolean isDoPostProcessing() {
        return this.postProcess;
    }

    @Override
    public void setDoPostProcessing(boolean postProcess) {
        this.postProcess = postProcess;
        GenericObjectEditor.setShowProperty(this.getClass(), "postProcessSteps", postProcess);
        GenericObjectEditor.setShowProperty(this.getClass(), "postProcessClusterSigma", postProcess);
        GenericObjectEditor.setShowProperty(this.getClass(), "printNBest", postProcess);
        GenericObjectEditor.setShowProperty(this.getClass(), "PPMethod", postProcess);
        GenericObjectEditor.setShowProperty(this.getClass(), "withPlot", postProcess);
        GenericObjectEditor.setShowProperty(this.getClass(), "accuracies", postProcess);
        GenericObjectEditor.setShowProperty(this.getClass(), "accAssumeConv", postProcess);
        GenericObjectEditor.setShowProperty(this.getClass(), "accMaxEval", postProcess);
    }

    @Override
    public String doPostProcessingTipText() {
        return "Toggle post processing of the solutions.";
    }

    @Override
    public double getPostProcessClusterSigma() {
        return this.postProcessClusterSigma;
    }

    @Override
    public void setPostProcessClusterSigma(double postProcessClusterSigma) {
        this.postProcessClusterSigma = postProcessClusterSigma;
    }

    @Override
    public String postProcessClusterSigmaTipText() {
        return "Set the sigma parameter for clustering during post processing; set to 0 for no clustering.";
    }

    @Override
    public String postProcessStepsTipText() {
        return "The number of HC post processing steps in fitness evaluations.";
    }

    @Override
    public int getPostProcessSteps() {
        return this.postProcessSteps;
    }

    @Override
    public void setPostProcessSteps(int ppSteps) {
        this.postProcessSteps = ppSteps;
    }

    @Override
    public int getPrintNBest() {
        return this.printNBest;
    }

    @Override
    public void setPrintNBest(int nBest) {
        this.printNBest = nBest;
    }

    @Override
    public String printNBestTipText() {
        return "Print as many solutions at max; set to -1 to print all";
    }

    public String getName() {
        return "PostProcessing " + (this.postProcess ? this.postProcessSteps + "/" + this.postProcessClusterSigma : "off");
    }

    @Override
    public PostProcessMethod getPPMethod() {
        return this.method;
    }

    @Override
    public String PPMethodTipText() {
        return "The method to use for post-processing.";
    }

    @Override
    public void setPPMethod(PostProcessMethod meth) {
        this.method = meth;
    }

    @Override
    public boolean isWithPlot() {
        return this.withPlot;
    }

    @Override
    public void setWithPlot(boolean withPlot) {
        this.withPlot = withPlot;
    }

    public double[] getAccuracies() {
        return this.accuracies;
    }

    public void setAccuracies(double[] accuracies) {
        this.accuracies = accuracies;
    }

    public String accuraciesTipText() {
        return "The accuracy thresholds to be tested";
    }

    public double getAccAssumeConv() {
        return this.accAssumeConv;
    }

    public void setAccAssumeConv(double accAssumeConv) {
        this.accAssumeConv = accAssumeConv;
    }

    public String accAssumeConvTipText() {
        return "The local search refinement is stopped earlier if the fitness changes less than this value";
    }

    public int getAccMaxEval() {
        return this.accMaxEval;
    }

    public void setAccMaxEval(int accMaxEval) {
        this.accMaxEval = accMaxEval;
    }

    public String accMaxEvalTipText() {
        return "The maximal number of evaluations (times dimension) for accuracy check or -1 to use the default.";
    }
}

