/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.postprocess;

import eva2.gui.BeanInspector;
import eva2.optimization.operator.postprocess.PostProcess;
import eva2.optimization.population.Population;
import eva2.problems.AbstractOptimizationProblem;
import eva2.problems.InterfaceInterestingHistogram;
import eva2.tools.math.Mathematics;
import java.util.Arrays;

public class SolutionHistogram {
    private double lBound;
    private double uBound;
    private int numBins;
    private int[] histogram;
    private int arity;

    public SolutionHistogram(double lower, double upper, int nBins) {
        this.lBound = lower;
        this.uBound = upper;
        this.numBins = nBins;
        this.histogram = new int[this.numBins];
        this.arity = 0;
    }

    public SolutionHistogram cloneEmpty() {
        return new SolutionHistogram(this.getLowerBound(), this.getUpperBound(), this.getNumBins());
    }

    public boolean isEmtpy() {
        return this.arity == 0;
    }

    private void setEntry(int i, int v) {
        this.histogram[i] = v;
    }

    public int getEntry(int i) {
        return this.histogram[i];
    }

    public double lowerBoundOfEntry(int i) {
        return this.lBound + (double)i * this.getStepSize();
    }

    public double upperBoundOfEntry(int i) {
        return this.lBound + (double)(i + 1) * this.getStepSize();
    }

    public double getLowerBound() {
        return this.lBound;
    }

    public double getUpperBound() {
        return this.uBound;
    }

    public int getNumBins() {
        return this.numBins;
    }

    public double getStepSize() {
        return (this.uBound - this.lBound) / (double)this.numBins;
    }

    public boolean isCompatible(SolutionHistogram o) {
        return this.lBound == o.getLowerBound() && this.uBound == o.getUpperBound() && this.numBins == o.getNumBins();
    }

    public void addHistogram(SolutionHistogram o) {
        if (o.isEmtpy()) {
            System.err.println("Warning, adding empty histogram... (SolutionHistogram)");
        }
        if (this.isCompatible(o)) {
            this.arity += o.arity;
            for (int i = 0; i < this.numBins; ++i) {
                int n = i;
                this.histogram[n] = this.histogram[n] + o.histogram[i];
            }
        }
    }

    public double[] getAverage() {
        double[] avg = new double[this.numBins];
        for (int i = 0; i < this.numBins; ++i) {
            avg[i] = (double)this.histogram[i] / (double)this.arity;
        }
        return avg;
    }

    public int sum() {
        return Mathematics.sum(this.histogram);
    }

    public String toString() {
        return "Hist(" + this.arity + "):" + this.lBound + "/" + this.uBound + "," + BeanInspector.toString(this.histogram) + ",Sc:" + this.getScore() + (this.arity > 1 ? ",Avg.Sc:" + this.getScore() / (double)this.arity : "");
    }

    public static void createFitNormHistogram(Population pop, SolutionHistogram hist, int crit) {
        hist.reset();
        if (pop.size() > 0) {
            if (pop.getBestFitness()[crit] < hist.getLowerBound()) {
                System.err.println("Warning, population contains solution with lower fitness than lower bound of the histogram!");
                System.err.println("Histogramm was " + hist.toString());
            }
            for (int i = 0; i < hist.getNumBins(); ++i) {
                hist.setEntry(i, PostProcess.filterFitnessIn(pop, hist.lowerBoundOfEntry(i), hist.upperBoundOfEntry(i), crit).size());
            }
        }
        hist.setSingularHist();
    }

    public static SolutionHistogram defaultEmptyHistogram(AbstractOptimizationProblem prob) {
        if (prob instanceof InterfaceInterestingHistogram) {
            return ((InterfaceInterestingHistogram)((Object)prob)).getHistogram();
        }
        return new SolutionHistogram(0.0, 100.0, 10);
    }

    private void setSingularHist() {
        this.arity = 1;
    }

    private void reset() {
        this.arity = 0;
        Arrays.fill(this.histogram, 0);
    }

    public void updateFrom(Population pop, int crit) {
        SolutionHistogram.createFitNormHistogram(pop, this, crit);
    }

    public static SolutionHistogram createFitNormHistogram(Population pop, double lowerBound, double upperBound, int nBins, int crit) {
        SolutionHistogram res = new SolutionHistogram(lowerBound, upperBound, nBins);
        SolutionHistogram.createFitNormHistogram(pop, res, crit);
        return res;
    }

    public double getScore() {
        double sc = 0.0;
        if (this.sum() > 0) {
            for (int i = this.numBins - 1; i >= 0; --i) {
                sc += this.getScalingFactor(i) * (double)this.getEntry(i);
            }
            return sc;
        }
        return 0.0;
    }

    private double getScalingFactor(int i) {
        return (double)(this.numBins - i) / (double)this.numBins;
    }
}

