/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.selection;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.selection.InterfaceSelection;
import eva2.optimization.population.Population;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="This method selects all individuals.")
public class SelectAll
implements InterfaceSelection,
Serializable {
    private boolean obeyDebsConstViolationPrinciple = true;

    public SelectAll() {
    }

    public SelectAll(SelectAll a) {
        this.obeyDebsConstViolationPrinciple = a.obeyDebsConstViolationPrinciple;
    }

    @Override
    public Object clone() {
        return new SelectAll(this);
    }

    @Override
    public void prepareSelection(Population population) {
    }

    @Override
    public Population selectFrom(Population population, int size) {
        Population result = new Population();
        result.setTargetSize(size);
        if (this.obeyDebsConstViolationPrinciple) {
            int index = 0;
            while (result.size() < size) {
                if (!((AbstractEAIndividual)population.get(index % population.size())).violatesConstraint()) {
                    result.add(population.get(index % population.size()));
                }
                if (++index < size || result.size() != 0) continue;
                for (int i = 0; i < size; ++i) {
                    result.add(population.get(i % population.size()));
                }
            }
        } else {
            for (int i = 0; i < size; ++i) {
                result.add(population.get(i % population.size()));
            }
        }
        return result;
    }

    @Override
    public Population findPartnerFor(AbstractEAIndividual dad, Population availablePartners, int size) {
        return this.selectFrom(availablePartners, size);
    }

    public String getName() {
        return "All Selection";
    }

    @Override
    public void setObeyDebsConstViolationPrinciple(boolean b) {
        this.obeyDebsConstViolationPrinciple = b;
    }

    public boolean getObeyDebsConstViolationPrinciple() {
        return this.obeyDebsConstViolationPrinciple;
    }

    public String obeyDebsConstViolationPrincipleToolTip() {
        return "Toggle the use of Deb's coonstraint violation principle.";
    }
}

