/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.selection;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.selection.InterfaceSelection;
import eva2.optimization.population.Population;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;
import java.util.ArrayList;

@Description(value="This selection method will select the n-Best individuals.This is a single objective selecting method, it will select in respect to a random criterion.")
public class SelectBestIndividuals
implements InterfaceSelection,
Serializable {
    private boolean obeyDebsConstViolationPrinciple = true;

    public SelectBestIndividuals() {
    }

    public SelectBestIndividuals(SelectBestIndividuals a) {
        this.obeyDebsConstViolationPrinciple = a.obeyDebsConstViolationPrinciple;
    }

    @Override
    public Object clone() {
        return new SelectBestIndividuals(this);
    }

    @Override
    public void prepareSelection(Population population) {
    }

    @Override
    public Population selectFrom(Population population, int size) {
        int i;
        Population result = new Population();
        int currentCriteria = 0;
        int critSize = ((AbstractEAIndividual)population.get(0)).getFitness().length;
        ArrayList[] bestIndividuals = new ArrayList[critSize];
        for (i = 0; i < critSize; ++i) {
            bestIndividuals[i] = new ArrayList();
            for (int j = 0; j < size; ++j) {
                bestIndividuals[i].add(this.getBestIndividualExcept(population, bestIndividuals[i], i));
            }
        }
        for (i = 0; i < size; ++i) {
            currentCriteria = RNG.randomInt(0, critSize - 1);
            result.add(bestIndividuals[currentCriteria].get(0));
            bestIndividuals[currentCriteria].remove(0);
        }
        return result;
    }

    private AbstractEAIndividual getBestIndividualExcept(Population pop, ArrayList tabu, int crit) {
        int index = -1;
        double bestProb = Double.POSITIVE_INFINITY;
        if (this.obeyDebsConstViolationPrinciple) {
            int j;
            boolean member;
            AbstractEAIndividual indy;
            int i;
            for (i = 0; i < pop.size(); ++i) {
                indy = (AbstractEAIndividual)pop.get(i);
                member = false;
                for (j = 0; j < tabu.size(); ++j) {
                    if (indy != tabu.get(j)) continue;
                    member = true;
                    break;
                }
                if (indy.violatesConstraint() || member || !(indy.getFitness(crit) < bestProb)) continue;
                index = i;
                bestProb = indy.getFitness(crit);
            }
            if (index >= 0) {
                return (AbstractEAIndividual)pop.get(index);
            }
            for (i = 0; i < pop.size(); ++i) {
                indy = (AbstractEAIndividual)pop.get(i);
                member = false;
                for (j = 0; j < tabu.size(); ++j) {
                    if (indy != tabu.get(j)) continue;
                    member = true;
                    break;
                }
                if (member || !(indy.getConstraintViolation() < bestProb)) continue;
                index = i;
                bestProb = indy.getConstraintViolation();
            }
            if (index >= 0) {
                return (AbstractEAIndividual)pop.get(index);
            }
            return (AbstractEAIndividual)pop.get(RNG.randomInt(0, pop.size() - 1));
        }
        for (int i = 0; i < pop.size(); ++i) {
            AbstractEAIndividual indy = (AbstractEAIndividual)pop.get(i);
            boolean member = false;
            for (int j = 0; j < tabu.size(); ++j) {
                if (indy != tabu.get(j)) continue;
                member = true;
                break;
            }
            if (member || !(indy.getFitness(crit) < bestProb)) continue;
            index = i;
            bestProb = indy.getFitness(crit);
        }
        if (index >= 0) {
            return (AbstractEAIndividual)pop.get(index);
        }
        return (AbstractEAIndividual)pop.get(RNG.randomInt(0, pop.size() - 1));
    }

    @Override
    public Population findPartnerFor(AbstractEAIndividual dad, Population availablePartners, int size) {
        return this.selectFrom(availablePartners, size);
    }

    public String getName() {
        return "Elitist Selection";
    }

    @Override
    public void setObeyDebsConstViolationPrinciple(boolean b) {
        this.obeyDebsConstViolationPrinciple = b;
    }

    public boolean getObeyDebsConstViolationPrinciple() {
        return this.obeyDebsConstViolationPrinciple;
    }

    public String obeyDebsConstViolationPrincipleToolTip() {
        return "Toggle the use of Deb's constraint violation principle.";
    }
}

