/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.selection;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.selection.InterfaceSelection;
import eva2.optimization.population.Population;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="This selection method will select the single Best individual (n-times if necessary).This is a single objective selecting method, it will select in respect to a random criterion.")
public class SelectBestSingle
implements InterfaceSelection,
Serializable {
    private boolean obeyDebsConstViolationPrinciple = true;
    private boolean excludeSelfAsPartner = true;

    public SelectBestSingle() {
    }

    public SelectBestSingle(boolean excludeSelfInPartners) {
        this.excludeSelfAsPartner = excludeSelfInPartners;
    }

    public SelectBestSingle(SelectBestSingle a) {
        this.obeyDebsConstViolationPrinciple = a.obeyDebsConstViolationPrinciple;
    }

    @Override
    public Object clone() {
        return new SelectBestSingle(this);
    }

    @Override
    public void prepareSelection(Population population) {
    }

    @Override
    public Population selectFrom(Population population, int size) {
        Population result = new Population();
        AbstractEAIndividual tmpIndy = null;
        int currentCriteria = 0;
        if (population.size() == 0) {
            return population;
        }
        int critSize = ((AbstractEAIndividual)population.get(0)).getFitness().length;
        result.setTargetSize(size);
        if (this.obeyDebsConstViolationPrinciple) {
            for (int i = 0; i < size; ++i) {
                int j;
                currentCriteria = RNG.randomInt(0, critSize - 1);
                double currentBestValue = Double.POSITIVE_INFINITY;
                tmpIndy = null;
                for (j = 0; j < population.size(); ++j) {
                    if (((AbstractEAIndividual)population.get(j)).violatesConstraint() || !(((AbstractEAIndividual)population.get(j)).getFitness(currentCriteria) < currentBestValue)) continue;
                    currentBestValue = ((AbstractEAIndividual)population.get(j)).getFitness(currentCriteria);
                    tmpIndy = (AbstractEAIndividual)population.get(j);
                }
                if (tmpIndy == null) {
                    for (j = 0; j < population.size(); ++j) {
                        if (!(((AbstractEAIndividual)population.get(j)).getConstraintViolation() < currentBestValue)) continue;
                        currentBestValue = ((AbstractEAIndividual)population.get(j)).getConstraintViolation();
                        tmpIndy = (AbstractEAIndividual)population.get(j);
                    }
                }
                result.add(tmpIndy);
            }
        } else {
            for (int i = 0; i < size; ++i) {
                currentCriteria = RNG.randomInt(0, critSize - 1);
                double currentBestValue = Double.POSITIVE_INFINITY;
                for (int j = 0; j < population.size(); ++j) {
                    if (!(((AbstractEAIndividual)population.get(j)).getFitness(currentCriteria) < currentBestValue)) continue;
                    currentBestValue = ((AbstractEAIndividual)population.get(j)).getFitness(currentCriteria);
                    tmpIndy = (AbstractEAIndividual)population.get(j);
                }
                result.add(tmpIndy);
            }
        }
        return result;
    }

    @Override
    public Population findPartnerFor(AbstractEAIndividual dad, Population availablePartners, int size) {
        if (this.excludeSelfAsPartner) {
            Population newPartners = availablePartners.filter(new Population().addToPop(dad));
            if (newPartners.size() == 0) {
                return newPartners;
            }
            return this.selectFrom(newPartners, size);
        }
        return this.selectFrom(availablePartners, size);
    }

    public String getName() {
        return "Totalitarian Selection";
    }

    @Override
    public void setObeyDebsConstViolationPrinciple(boolean b) {
        this.obeyDebsConstViolationPrinciple = b;
    }

    public boolean getObeyDebsConstViolationPrinciple() {
        return this.obeyDebsConstViolationPrinciple;
    }

    public String obeyDebsConstViolationPrincipleToolTip() {
        return "Toggle the use of Deb's coonstraint violation principle.";
    }

    public boolean isExcludeSelfAsPartner() {
        return this.excludeSelfAsPartner;
    }

    public void setExcludeSelfAsPartner(boolean excludeSelfAsPartner) {
        this.excludeSelfAsPartner = excludeSelfAsPartner;
    }

    public String excludeSelfAsPartnerTipText() {
        return "When employed for partner selection, the partners may be allowed to contain the parents itself or not.";
    }
}

