/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.selection;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.selection.InterfaceSelection;
import eva2.optimization.population.Population;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;
import java.util.ArrayList;

@Description(value="The EP tournament selection performs a number of tournaments per individual, the winner is assigned a point. The individuals with the most points are selected. This is a single objective selecting method, it will select in respect to a random criterion.")
public class SelectEPTournaments
implements InterfaceSelection,
Serializable {
    private int tournamentSize = 4;
    private int tournaments = 10;
    private boolean obeyDebsConstViolationPrinciple = true;
    private int[][] victories;

    public SelectEPTournaments() {
    }

    public SelectEPTournaments(SelectEPTournaments a) {
        this.tournamentSize = a.tournamentSize;
        this.obeyDebsConstViolationPrinciple = a.obeyDebsConstViolationPrinciple;
    }

    @Override
    public Object clone() {
        return new SelectEPTournaments(this);
    }

    @Override
    public void prepareSelection(Population population) {
        int j;
        int i;
        int[] best = new int[population.getBestEAIndividual().getFitness().length];
        this.victories = new int[population.size()][population.getBestEAIndividual().getFitness().length];
        for (i = 0; i < this.victories.length; ++i) {
            for (j = 0; j < this.victories[i].length; ++j) {
                this.victories[i][j] = 0;
            }
        }
        for (i = 0; i < population.size(); ++i) {
            for (j = 0; j < this.tournaments; ++j) {
                int k;
                for (k = 0; k < best.length; ++k) {
                    best[k] = i;
                }
                for (k = 0; k < this.tournamentSize; ++k) {
                    int rand = RNG.randomInt(0, population.size() - 1);
                    AbstractEAIndividual tmpIndy = (AbstractEAIndividual)population.get(rand);
                    for (int l = 0; l < best.length; ++l) {
                        if (this.obeyDebsConstViolationPrinciple) {
                            if (tmpIndy.violatesConstraint() || !(tmpIndy.getFitness(l) < ((AbstractEAIndividual)population.get(best[l])).getFitness(l))) continue;
                            best[l] = rand;
                            continue;
                        }
                        if (!(tmpIndy.getFitness(l) < ((AbstractEAIndividual)population.get(best[l])).getFitness(l))) continue;
                        best[l] = rand;
                    }
                }
                k = 0;
                while (k < best.length) {
                    int[] nArray = this.victories[best[k]];
                    int n = k++;
                    nArray[n] = nArray[n] + 1;
                }
            }
        }
    }

    @Override
    public Population selectFrom(Population population, int size) {
        int i;
        Population result = new Population();
        int currentCriteria = 0;
        int critSize = ((AbstractEAIndividual)population.get(0)).getFitness().length;
        ArrayList[] bestIndividuals = new ArrayList[critSize];
        for (i = 0; i < critSize; ++i) {
            bestIndividuals[i] = new ArrayList();
            for (int j = 0; j < size; ++j) {
                bestIndividuals[i].add(this.getBestIndividualExcept(population, bestIndividuals[i], i));
            }
        }
        for (i = 0; i < size; ++i) {
            currentCriteria = RNG.randomInt(0, critSize - 1);
            result.add(bestIndividuals[currentCriteria].get(0));
            bestIndividuals[currentCriteria].remove(0);
        }
        return result;
    }

    private AbstractEAIndividual getBestIndividualExcept(Population pop, ArrayList tabu, int crit) {
        int index = -1;
        int mostVictories = -1;
        for (int i = 0; i < pop.size(); ++i) {
            AbstractEAIndividual indy = (AbstractEAIndividual)pop.get(i);
            boolean member = false;
            for (int j = 0; j < tabu.size(); ++j) {
                if (indy != tabu.get(j)) continue;
                member = true;
                break;
            }
            if (member || this.victories[i][crit] <= mostVictories) continue;
            index = i;
            mostVictories = this.victories[i][crit];
        }
        if (index >= 0) {
            return (AbstractEAIndividual)pop.get(index);
        }
        return (AbstractEAIndividual)pop.get(RNG.randomInt(0, pop.size() - 1));
    }

    @Override
    public Population findPartnerFor(AbstractEAIndividual dad, Population availablePartners, int size) {
        return this.selectFrom(availablePartners, size);
    }

    public String getName() {
        return "EP Tournament Selection";
    }

    public String tournamentSizeTipText() {
        return "Choose the tournament size.";
    }

    public int getTournamentSize() {
        return this.tournamentSize;
    }

    public void setTournamentSize(int g) {
        this.tournamentSize = g;
    }

    public String tournamentsTipText() {
        return "Choose the number of tournaments.";
    }

    public int getTournaments() {
        return this.tournaments;
    }

    public void setTournaments(int g) {
        this.tournaments = g;
    }

    @Override
    public void setObeyDebsConstViolationPrinciple(boolean b) {
        this.obeyDebsConstViolationPrinciple = b;
    }

    public boolean getObeyDebsConstViolationPrinciple() {
        return this.obeyDebsConstViolationPrinciple;
    }

    public String obeyDebsConstViolationPrincipleToolTip() {
        return "Toggle the use of Deb's coonstraint violation principle.";
    }
}

