/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.selection;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.distancemetric.InterfaceDistanceMetric;
import eva2.optimization.operator.distancemetric.ObjectiveSpaceMetric;
import eva2.optimization.operator.selection.SelectTournament;
import eva2.optimization.population.Population;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="This selection will select n mates from all individuals within the mating distance (extends Tournament Selection).This is a single objective selecting method, it will select in respect to a random criterion.")
public class SelectHomologousMate
extends SelectTournament
implements Serializable {
    private double matingRadius = 0.1;
    private InterfaceDistanceMetric metric = new ObjectiveSpaceMetric();

    public SelectHomologousMate() {
    }

    public SelectHomologousMate(SelectHomologousMate a) {
        this.matingRadius = a.matingRadius;
        this.metric = (InterfaceDistanceMetric)a.metric.clone();
    }

    @Override
    public Object clone() {
        return new SelectHomologousMate(this);
    }

    @Override
    public void prepareSelection(Population population) {
    }

    @Override
    public Population findPartnerFor(AbstractEAIndividual dad, Population availablePartners, int size) {
        Population possibleMates = new Population();
        for (int i = 0; i < availablePartners.size(); ++i) {
            if (!(this.metric.distance(dad, (AbstractEAIndividual)availablePartners.get(i)) < this.matingRadius)) continue;
            possibleMates.add(availablePartners.get(i));
        }
        if (possibleMates.size() <= 1) {
            return this.selectFrom(availablePartners, size);
        }
        return this.selectFrom(possibleMates, size);
    }

    @Override
    public String getName() {
        return "Homologous Mating Selection";
    }

    public double getMatingRadius() {
        return this.matingRadius;
    }

    public void setMatingRadius(double b) {
        this.matingRadius = b;
    }

    public String matingRadiusTipText() {
        return "Choose the mating radius.";
    }

    public void setMetric(InterfaceDistanceMetric Metric) {
        this.metric = Metric;
    }

    public InterfaceDistanceMetric getMetric() {
        return this.metric;
    }

    public String metricTipText() {
        return "The distance metric used. Note: This depends on the type of EAIndividual used!";
    }
}

