/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.selection;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.selection.InterfaceSelection;
import eva2.optimization.operator.selection.MOMultipleSolutions;
import eva2.optimization.operator.selection.SelectBestIndividuals;
import eva2.optimization.population.Population;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="This selection method only works for MOMA-II, it selects an individual depending on the number of non-dominated solutions.")
public class SelectMOMAIIDominanceCounter
implements InterfaceSelection,
Serializable {
    private InterfaceSelection selection = new SelectBestIndividuals();
    private boolean obeyDebsConstViolationPrinciple = true;

    public SelectMOMAIIDominanceCounter() {
    }

    public SelectMOMAIIDominanceCounter(SelectMOMAIIDominanceCounter a) {
        this.selection = (InterfaceSelection)a.selection.clone();
        this.obeyDebsConstViolationPrinciple = a.obeyDebsConstViolationPrinciple;
    }

    @Override
    public Object clone() {
        return new SelectMOMAIIDominanceCounter(this);
    }

    @Override
    public void prepareSelection(Population population) {
        Object tmpObj;
        AbstractEAIndividual tmpIndy1;
        int i;
        for (i = 0; i < population.size(); ++i) {
            tmpIndy1 = (AbstractEAIndividual)population.get(i);
            tmpObj = tmpIndy1.getData("MOMAII");
            if (tmpObj == null || !(tmpObj instanceof MOMultipleSolutions)) continue;
            ((MOMultipleSolutions)tmpObj).reset();
        }
        for (i = 0; i < population.size(); ++i) {
            tmpIndy1 = (AbstractEAIndividual)population.get(i);
            tmpObj = tmpIndy1.getData("MOMAII");
            if (tmpObj != null && tmpObj instanceof MOMultipleSolutions) {
                MOMultipleSolutions malta = (MOMultipleSolutions)tmpObj;
                for (int j = i + 1; j < population.size(); ++j) {
                    AbstractEAIndividual tmpIndy2 = (AbstractEAIndividual)population.get(j);
                    tmpObj = tmpIndy2.getData("MOMAII");
                    if (tmpObj == null || !(tmpObj instanceof MOMultipleSolutions)) continue;
                    MOMultipleSolutions tmpMalta = (MOMultipleSolutions)tmpObj;
                    malta.testDominance(tmpMalta);
                }
                int domCount = 0;
                for (int j = 0; j < malta.size(); ++j) {
                    if (!malta.get((int)i).isDominant) continue;
                    ++domCount;
                }
                malta.sizeDominantSolutions = domCount;
                double[] fitness = new double[]{1.0 / (double)(domCount + 1)};
                tmpIndy1.setFitness(fitness);
                continue;
            }
            double[] fitness = new double[]{2.0};
            tmpIndy1.setFitness(fitness);
        }
    }

    @Override
    public Population selectFrom(Population population, int size) {
        return this.selection.selectFrom(population, size);
    }

    @Override
    public Population findPartnerFor(AbstractEAIndividual dad, Population availablePartners, int size) {
        return this.selectFrom(availablePartners, size);
    }

    public String getName() {
        return "MOMAII-DonCount";
    }

    public void setSelectionMethod(InterfaceSelection pop) {
        this.selection = pop;
    }

    public InterfaceSelection getSelectionMethod() {
        return this.selection;
    }

    public String selectionMethodTipText() {
        return "Choose the selection method (single-criteria ones please).";
    }

    @Override
    public void setObeyDebsConstViolationPrinciple(boolean b) {
        this.obeyDebsConstViolationPrinciple = b;
    }

    public boolean getObeyDebsConstViolationPrinciple() {
        return this.obeyDebsConstViolationPrinciple;
    }

    public String obeyDebsConstViolationPrincipleToolTip() {
        return "Toggle the use of Deb's coonstraint violation principle.";
    }
}

