/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.selection;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.archiving.ArchivingNSGAII;
import eva2.optimization.operator.selection.InterfaceSelection;
import eva2.optimization.population.Population;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="The Crowded Tournament Selection first chooses the better Pareto Front and then the smaller Crowding Distance.")
public class SelectMONSGAIICrowedTournament
implements InterfaceSelection,
Serializable {
    private int tournamentSize = 4;
    private ArchivingNSGAII NSGAII = new ArchivingNSGAII();
    private Population[] fronts;
    private boolean obeyDebsConstViolationPrinciple = true;

    public SelectMONSGAIICrowedTournament() {
    }

    public SelectMONSGAIICrowedTournament(SelectMONSGAIICrowedTournament a) {
        this.tournamentSize = a.tournamentSize;
        this.NSGAII = new ArchivingNSGAII();
        this.obeyDebsConstViolationPrinciple = a.obeyDebsConstViolationPrinciple;
    }

    @Override
    public Object clone() {
        return new SelectMONSGAIICrowedTournament(this);
    }

    @Override
    public void prepareSelection(Population population) {
        this.fronts = this.NSGAII.getNonDominatedSortedFronts(population);
        this.NSGAII.calculateCrowdingDistance(this.fronts);
    }

    @Override
    public Population selectFrom(Population population, int size) {
        Population result = new Population();
        result.setTargetSize(size);
        for (int i = 0; i < size; ++i) {
            result.add(this.select(population));
        }
        return result;
    }

    private AbstractEAIndividual select(Population population) {
        AbstractEAIndividual result = null;
        Population feasiblePop = new Population();
        Population infeasiblePop = new Population();
        int smallestLevel = Integer.MAX_VALUE;
        try {
            int tmpL;
            AbstractEAIndividual tmpIndy;
            int i;
            for (i = 0; i < this.tournamentSize; ++i) {
                tmpIndy = (AbstractEAIndividual)population.get(RNG.randomInt(0, population.size() - 1));
                tmpL = (Integer)tmpIndy.getData("ParetoLevel");
                if (tmpL < smallestLevel) {
                    smallestLevel = tmpL;
                }
                if (tmpIndy.getConstraintViolation() > 0.0) {
                    infeasiblePop.add(tmpIndy);
                    continue;
                }
                feasiblePop.add(tmpIndy);
            }
            if (feasiblePop.size() == 0) {
                int best = 0;
                for (int i2 = 1; i2 < infeasiblePop.size(); ++i2) {
                    if (!(((AbstractEAIndividual)infeasiblePop.get(i2)).getConstraintViolation() < ((AbstractEAIndividual)infeasiblePop.get(best)).getConstraintViolation())) continue;
                    best = i2;
                }
                return (AbstractEAIndividual)infeasiblePop.get(best);
            }
            smallestLevel = Integer.MAX_VALUE;
            for (i = 0; i < feasiblePop.size(); ++i) {
                tmpIndy = (AbstractEAIndividual)feasiblePop.get(i);
                tmpL = (Integer)tmpIndy.getData("ParetoLevel");
                if (tmpL >= smallestLevel) continue;
                smallestLevel = tmpL;
            }
            for (i = 0; i < feasiblePop.size(); ++i) {
                if ((Integer)((AbstractEAIndividual)feasiblePop.get(i)).getData("ParetoLevel") <= smallestLevel) continue;
                feasiblePop.remove(i);
                --i;
            }
            if (feasiblePop.size() == 1) {
                return (AbstractEAIndividual)feasiblePop.get(0);
            }
            result = (AbstractEAIndividual)feasiblePop.get(0);
            double curCrowdingDistance = (Double)result.getData("HyperCube");
            for (i = 1; i < feasiblePop.size(); ++i) {
                double tmpCrowdingDistance = (Double)((AbstractEAIndividual)feasiblePop.get(i)).getData("HyperCube");
                if (!(tmpCrowdingDistance > curCrowdingDistance)) continue;
                curCrowdingDistance = tmpCrowdingDistance;
                result = (AbstractEAIndividual)feasiblePop.get(i);
            }
        }
        catch (IndexOutOfBoundsException e) {
            System.out.println("Tournament Selection produced IndexOutOfBoundsException!");
            System.out.println("Feasible population size   : " + feasiblePop.size());
            System.out.println("Infeasible population size : " + infeasiblePop.size());
            result = population.getBestEAIndividual();
        }
        return result;
    }

    @Override
    public Population findPartnerFor(AbstractEAIndividual dad, Population availablePartners, int size) {
        return this.selectFrom(availablePartners, size);
    }

    public String getName() {
        return "MO Crowded Tournament Selection";
    }

    public String tournamentSizeTipText() {
        return "Choose the tournament size.";
    }

    public int getTournamentSize() {
        return this.tournamentSize;
    }

    public void setTournamentSize(int g) {
        this.tournamentSize = g;
    }

    @Override
    public void setObeyDebsConstViolationPrinciple(boolean b) {
        this.obeyDebsConstViolationPrinciple = b;
    }

    public boolean getObeyDebsConstViolationPrinciple() {
        return this.obeyDebsConstViolationPrinciple;
    }

    public String obeyDebsConstViolationPrincipleToolTip() {
        return "Toggle the use of Deb's coonstraint violation principle.";
    }
}

