/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.selection;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.IndividualInterface;
import eva2.optimization.operator.selection.InterfaceSelection;
import eva2.optimization.operator.selection.SelectBestIndividuals;
import eva2.optimization.population.Population;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="This selection method will select all non-dominated individuals. Therefore the target size of the selection may be exceeded.")
public class SelectMONonDominated
implements InterfaceSelection,
Serializable {
    private boolean obeyDebsConstViolationPrinciple = true;

    public SelectMONonDominated() {
    }

    public SelectMONonDominated(SelectMONonDominated a) {
        this.obeyDebsConstViolationPrinciple = a.obeyDebsConstViolationPrinciple;
    }

    @Override
    public Object clone() {
        return new SelectMONonDominated(this);
    }

    @Override
    public void prepareSelection(Population population) {
    }

    @Override
    public Population selectFrom(Population population, int size) {
        Population result = new Population();
        int index = RNG.randomInt(0, population.size() - 1);
        if (this.obeyDebsConstViolationPrinciple) {
            boolean feasible = false;
            for (int i = 0; i < population.size(); ++i) {
                if (((AbstractEAIndividual)population.get(i)).getConstraintViolation() != 0.0) continue;
                feasible = true;
            }
            if (feasible) {
                while (result.size() < size) {
                    int tmpI = index % population.size();
                    if (tmpI < 0) {
                        System.out.println("Index:      " + index);
                        System.out.println("Pop.Size(): " + population.size());
                        tmpI = 0;
                    }
                    if (((AbstractEAIndividual)population.get(tmpI)).getConstraintViolation() == 0.0 && this.isDominant((AbstractEAIndividual)population.get(tmpI), population)) {
                        result.addIndividual((IndividualInterface)population.get(index % population.size()));
                    }
                    ++index;
                }
            } else {
                SelectBestIndividuals select = new SelectBestIndividuals();
                result = select.selectFrom(population, size);
            }
        } else {
            while (result.size() < size) {
                int tmpI = index % population.size();
                if (tmpI < 0) {
                    System.out.println("Index:      " + index);
                    System.out.println("Pop.Size(): " + population.size());
                    tmpI = 0;
                }
                if (this.isDominant((AbstractEAIndividual)population.get(tmpI), population)) {
                    result.addIndividual((IndividualInterface)population.get(index % population.size()));
                }
                ++index;
            }
        }
        return result;
    }

    @Override
    public Population findPartnerFor(AbstractEAIndividual dad, Population availablePartners, int size) {
        return this.selectFrom(availablePartners, size);
    }

    public boolean isDominant(AbstractEAIndividual indy, Population pop) {
        if (this.obeyDebsConstViolationPrinciple) {
            for (int i = 0; i < pop.size(); ++i) {
                if (indy.equals(pop.get(i)) || !((AbstractEAIndividual)pop.get(i)).isDominatingDebConstraintsEqual(indy)) continue;
                return false;
            }
        } else {
            for (int i = 0; i < pop.size(); ++i) {
                if (indy.equals(pop.get(i)) || !((AbstractEAIndividual)pop.get(i)).isDominatingEqual(indy)) continue;
                return false;
            }
        }
        return true;
    }

    public String getName() {
        return "Non-Dominated Selection";
    }

    @Override
    public void setObeyDebsConstViolationPrinciple(boolean b) {
        this.obeyDebsConstViolationPrinciple = b;
    }

    public boolean getObeyDebsConstViolationPrinciple() {
        return this.obeyDebsConstViolationPrinciple;
    }

    public String obeyDebsConstViolationPrincipleToolTip() {
        return "Toggle the use of Deb's coonstraint violation principle.";
    }
}

