/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.selection;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.archiving.ArchivingPESAII;
import eva2.optimization.operator.selection.InterfaceSelection;
import eva2.optimization.population.Population;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="Performs a binary tournament selection, preferring the individual with the smaller squeezing factor.")
public class SelectMOPESA
implements InterfaceSelection,
Serializable {
    ArchivingPESAII PESAII = new ArchivingPESAII();
    int[] squeeze;
    int tournamentSize = 2;
    boolean obeyDebsConstViolationPrinciple = true;

    public SelectMOPESA() {
    }

    public SelectMOPESA(SelectMOPESA a) {
        this.PESAII = new ArchivingPESAII();
        this.tournamentSize = a.tournamentSize;
        this.obeyDebsConstViolationPrinciple = a.obeyDebsConstViolationPrinciple;
    }

    @Override
    public Object clone() {
        return new SelectMOPESA(this);
    }

    @Override
    public void prepareSelection(Population population) {
        this.squeeze = this.PESAII.calculateSqueezeFactor(population);
    }

    @Override
    public Population selectFrom(Population population, int size) {
        Population result = new Population();
        result.setTargetSize(size);
        for (int i = 0; i < size; ++i) {
            result.add(this.select(population));
        }
        return result;
    }

    private AbstractEAIndividual select(Population population) {
        AbstractEAIndividual resultIndy;
        try {
            int winner = RNG.randomInt(0, population.size() - 1);
            for (int i = 1; i < this.tournamentSize; ++i) {
                int tmp = RNG.randomInt(0, population.size() - 1);
                if (this.squeeze[tmp] >= this.squeeze[winner]) continue;
                winner = tmp;
            }
            resultIndy = (AbstractEAIndividual)population.get(winner);
        }
        catch (IndexOutOfBoundsException e) {
            System.out.println("Tournament Selection produced IndexOutOfBoundsException!");
            resultIndy = population.getBestEAIndividual();
        }
        return resultIndy;
    }

    @Override
    public Population findPartnerFor(AbstractEAIndividual dad, Population availablePartners, int size) {
        return this.selectFrom(availablePartners, size);
    }

    public String getName() {
        return "PESA Selection";
    }

    public String tournamentSizeTipText() {
        return "Choose the tournament size.";
    }

    public int getTournamentSize() {
        return this.tournamentSize;
    }

    public void setTournamentSize(int g) {
        this.tournamentSize = g;
    }

    @Override
    public void setObeyDebsConstViolationPrinciple(boolean b) {
        this.obeyDebsConstViolationPrinciple = b;
    }

    public boolean getObeyDebsConstViolationPrinciple() {
        return this.obeyDebsConstViolationPrinciple;
    }

    public String obeyDebsConstViolationPrincipleToolTip() {
        return "Toggle the use of Deb's coonstraint violation principle.";
    }
}

