/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.selection;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.archiving.ArchivingPESAII;
import eva2.optimization.operator.selection.InterfaceSelection;
import eva2.optimization.population.Population;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

@Description(value="Performs a binary tournament selection, preferring the gridbox of smaller squeezing factor and selecting a random individual from the winner box.")
public class SelectMOPESAII
implements InterfaceSelection,
Serializable {
    ArchivingPESAII PESAII = new ArchivingPESAII();
    int[] squeeze;
    int tournamentSize = 2;
    ArrayList gridBoxes;
    boolean obeyDebsConstViolationPrinciple = true;

    public SelectMOPESAII() {
    }

    public SelectMOPESAII(SelectMOPESAII a) {
        this.PESAII = new ArchivingPESAII();
        this.tournamentSize = a.tournamentSize;
        this.obeyDebsConstViolationPrinciple = a.obeyDebsConstViolationPrinciple;
    }

    @Override
    public Object clone() {
        return new SelectMOPESAII(this);
    }

    @Override
    public void prepareSelection(Population population) {
        this.squeeze = this.PESAII.calculateSqueezeFactor(population);
        Hashtable<String, ArrayList> tmpGridBoxes = new Hashtable<String, ArrayList>();
        for (int i = 0; i < population.size(); ++i) {
            ArrayList tmp;
            AbstractEAIndividual tmpIndy = (AbstractEAIndividual)population.get(i);
            int[] gridBox = (int[])tmpIndy.getData("GridBox");
            String tmpString = "";
            for (int j = 0; j < gridBox.length; ++j) {
                tmpString = tmpString + gridBox[j] + "/";
            }
            if (tmpGridBoxes.get(tmpString) == null) {
                tmp = new ArrayList();
                tmpGridBoxes.put(tmpString, tmp);
            } else {
                tmp = (ArrayList)tmpGridBoxes.get(tmpString);
            }
            tmp.add(tmpIndy);
        }
        this.gridBoxes = new ArrayList();
        Enumeration myEnum = tmpGridBoxes.elements();
        while (myEnum.hasMoreElements()) {
            this.gridBoxes.add(myEnum.nextElement());
        }
    }

    @Override
    public Population selectFrom(Population population, int size) {
        Population result = new Population();
        result.setTargetSize(size);
        for (int i = 0; i < size; ++i) {
            result.add(this.select(population));
        }
        return result;
    }

    private AbstractEAIndividual select(Population population) {
        AbstractEAIndividual resultIndy;
        try {
            ArrayList box1 = (ArrayList)this.gridBoxes.get(RNG.randomInt(0, this.gridBoxes.size() - 1));
            ArrayList box2 = (ArrayList)this.gridBoxes.get(RNG.randomInt(0, this.gridBoxes.size() - 1));
            resultIndy = (Integer)((AbstractEAIndividual)box1.get(0)).getData("SqueezeFactor") < (Integer)((AbstractEAIndividual)box2.get(0)).getData("SqueezeFactor") ? (AbstractEAIndividual)box1.get(RNG.randomInt(0, box1.size() - 1)) : (AbstractEAIndividual)box2.get(RNG.randomInt(0, box2.size() - 1));
        }
        catch (IndexOutOfBoundsException e) {
            System.out.println("Tournament Selection produced IndexOutOfBoundsException!");
            resultIndy = population.getBestEAIndividual();
        }
        return resultIndy;
    }

    @Override
    public Population findPartnerFor(AbstractEAIndividual dad, Population availablePartners, int size) {
        return this.selectFrom(availablePartners, size);
    }

    public String getName() {
        return "PESAII Selection";
    }

    @Override
    public void setObeyDebsConstViolationPrinciple(boolean b) {
        this.obeyDebsConstViolationPrinciple = b;
    }

    public boolean getObeyDebsConstViolationPrinciple() {
        return this.obeyDebsConstViolationPrinciple;
    }

    public String obeyDebsConstViolationPrincipleToolTip() {
        return "Toggle the use of Deb's coonstraint violation principle.";
    }
}

