/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.selection;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.archiving.ArchivingSPEAII;
import eva2.optimization.operator.selection.InterfaceSelection;
import eva2.optimization.operator.selection.SelectTournament;
import eva2.optimization.population.Population;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="This selection method calucates the strength and selects using the strength.")
public class SelectMOSPEAII
implements InterfaceSelection,
Serializable {
    private InterfaceSelection environmentSelection = new SelectTournament();
    private ArchivingSPEAII SPEAII = new ArchivingSPEAII();
    private double[] SPEAFitness;
    private boolean obeyDebsConstViolationPrinciple = true;

    public SelectMOSPEAII() {
    }

    public SelectMOSPEAII(SelectMOSPEAII a) {
        this.SPEAII = new ArchivingSPEAII();
        this.environmentSelection = (InterfaceSelection)a.environmentSelection.clone();
        this.obeyDebsConstViolationPrinciple = a.obeyDebsConstViolationPrinciple;
    }

    @Override
    public Object clone() {
        return new SelectMOSPEAII(this);
    }

    @Override
    public void prepareSelection(Population population) {
        this.SPEAFitness = this.SPEAII.calculateSPEA(population);
    }

    @Override
    public Population selectFrom(Population population, int size) {
        double[][] orgFit = new double[population.size()][];
        double[] newFit = new double[1];
        for (int i = 0; i < population.size(); ++i) {
            orgFit[i] = ((AbstractEAIndividual)population.get(i)).getFitness();
            newFit = new double[]{this.SPEAFitness[i]};
            ((AbstractEAIndividual)population.get(i)).setFitness(newFit);
        }
        Population result = this.environmentSelection.selectFrom(population, size);
        for (int i = 0; i < population.size(); ++i) {
            ((AbstractEAIndividual)population.get(i)).setFitness(orgFit[i]);
        }
        return result;
    }

    @Override
    public Population findPartnerFor(AbstractEAIndividual dad, Population availablePartners, int size) {
        return this.selectFrom(availablePartners, size);
    }

    public String getName() {
        return "MO SPEAII selection";
    }

    public void setEnvironmentSelection(InterfaceSelection selection) {
        this.environmentSelection = selection;
    }

    public InterfaceSelection getEnvironmentSelection() {
        return this.environmentSelection;
    }

    public String environmentSelectionTipText() {
        return "Choose a method for selecting the reduced population.";
    }

    @Override
    public void setObeyDebsConstViolationPrinciple(boolean b) {
        this.obeyDebsConstViolationPrinciple = b;
    }

    public boolean getObeyDebsConstViolationPrinciple() {
        return this.obeyDebsConstViolationPrinciple;
    }

    public String obeyDebsConstViolationPrincipleToolTip() {
        return "Toggle the use of Deb's coonstraint violation principle.";
    }
}

