/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.selection;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.selection.InterfaceSelection;
import eva2.optimization.operator.selection.probability.InterfaceSelectionProbability;
import eva2.optimization.operator.selection.probability.SelProbStandard;
import eva2.optimization.operator.selection.probability.SelProbStandardScaling;
import eva2.optimization.population.Population;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="This method chooses individuals similar to the static roulette wheel. The chance for each individual to be selected depends on the selection probability. The selection probability is 1 for all Individuals with a fitness that is bigger than the midean fitness.This is a single objective selecting method, it will select in respect to a random criterion.")
public class SelectParticleWheel
implements InterfaceSelection,
Serializable {
    private boolean obeyDebsConstViolationPrinciple = true;
    private static final long serialVersionUID = 1L;
    private InterfaceSelectionProbability selProbCalculator = new SelProbStandard();
    private boolean selectFixedSteps = false;

    public SelectParticleWheel() {
    }

    public SelectParticleWheel(double scalingProb) {
        this.selProbCalculator = new SelProbStandardScaling(scalingProb);
    }

    public SelectParticleWheel(InterfaceSelectionProbability selProb) {
        this.selProbCalculator = selProb;
    }

    public SelectParticleWheel(SelectParticleWheel a) {
        this.selProbCalculator = (InterfaceSelectionProbability)a.selProbCalculator.clone();
        this.obeyDebsConstViolationPrinciple = a.obeyDebsConstViolationPrinciple;
    }

    @Override
    public Object clone() {
        return new SelectParticleWheel(this);
    }

    @Override
    public void prepareSelection(Population population) {
        this.selProbCalculator.computeSelectionProbability(population, "Fitness", this.obeyDebsConstViolationPrinciple);
    }

    @Override
    public Population selectFrom(Population population, int size) {
        Population result = new Population();
        result.setTargetSize(size);
        if (this.selectFixedSteps) {
            this.selectFixed(population, size, result);
        } else {
            this.selectDrawIndependent(population, size, result);
        }
        return result;
    }

    private void selectDrawIndependent(Population population, int size, Population result) {
        double sum = 0.0;
        double selPoint = 0.0;
        for (int i = 0; i < size; ++i) {
            selPoint = RNG.randomDouble();
            int selIndex = 0;
            for (sum = ((AbstractEAIndividual)population.getIndividual(0)).getSelectionProbability(0); selPoint >= sum; sum += ((AbstractEAIndividual)population.getIndividual(++selIndex)).getSelectionProbability(0)) {
            }
            result.add((AbstractEAIndividual)((AbstractEAIndividual)population.get(selIndex)).clone());
            ((AbstractEAIndividual)result.getIndividual(i)).setAge(0);
        }
    }

    private void selectFixed(Population population, int size, Population result) {
        double segment = 1.0 / (double)(size + 1);
        double selPoint = RNG.randomDouble(0.0, segment);
        int selIndex = 0;
        double selFitSum = ((AbstractEAIndividual)population.getIndividual(selIndex)).getSelectionProbability(0);
        for (int i = 0; i < size; ++i) {
            while (selFitSum < selPoint) {
                selFitSum += ((AbstractEAIndividual)population.getIndividual(++selIndex)).getSelectionProbability(0);
            }
            result.add((AbstractEAIndividual)((AbstractEAIndividual)population.get(selIndex)).clone());
            ((AbstractEAIndividual)result.getIndividual(i)).setAge(0);
            selPoint += segment;
        }
    }

    @Override
    public Population findPartnerFor(AbstractEAIndividual dad, Population availablePartners, int size) {
        return this.selectFrom(availablePartners, size);
    }

    public String getName() {
        return "Particle Wheel Selection";
    }

    @Override
    public void setObeyDebsConstViolationPrinciple(boolean b) {
        this.obeyDebsConstViolationPrinciple = b;
    }

    public boolean getObeyDebsConstViolationPrinciple() {
        return this.obeyDebsConstViolationPrinciple;
    }

    public String obeyDebsConstViolationPrincipleToolTip() {
        return "Toggle the use of Deb's coonstraint violation principle(todo).";
    }

    public boolean isSelectFixedSteps() {
        return this.selectFixedSteps;
    }

    public void setSelectFixedSteps(boolean selectFixedSteps) {
        this.selectFixedSteps = selectFixedSteps;
    }

    public String selectFixedStepsTipText() {
        return "Use fixed segment wheel for selection if marked or independent draws if not.";
    }

    public InterfaceSelectionProbability getSelProbCalculator() {
        return this.selProbCalculator;
    }

    public void setSelProbCalculator(InterfaceSelectionProbability selProbCalculator) {
        this.selProbCalculator = selProbCalculator;
    }

    public String selProbCalculatorTipText() {
        return "The method for calculating selection probability from the fitness.";
    }
}

